'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useComboboxFilter", {
    enumerable: true,
    get: function() {
        return useComboboxFilter;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _Option = require("../Option");
function defaultFilter(optionText, query) {
    if (query === '') {
        return true;
    }
    return optionText.toLowerCase().includes(query.toLowerCase());
}
function defaultToString(option) {
    return typeof option === 'string' ? option : option.value;
}
function useComboboxFilter(query, options, config) {
    const { filter = defaultFilter, noOptionsMessage = "We couldn't find any matches.", optionToReactKey = defaultToString, optionToText = defaultToString, renderOption = (option)=>{
        if (typeof option === 'string') {
            return /*#__PURE__*/ _react.createElement(_Option.Option, {
                key: option
            }, option);
        }
        return /*#__PURE__*/ _react.createElement(_Option.Option, {
            ...option,
            key: optionToReactKey(option),
            text: optionToText(option),
            value: option.value
        }, option.children);
    } } = config;
    const filteredOptions = _react.useMemo(()=>{
        const searchValue = query.trim();
        return options.filter((option)=>filter(optionToText(option), searchValue));
    }, [
        options,
        optionToText,
        filter,
        query
    ]);
    if (filteredOptions.length === 0) {
        return [
            /*#__PURE__*/ _react.createElement(_Option.Option, {
                "aria-disabled": "true",
                key: "no-results",
                text: ""
            }, noOptionsMessage)
        ];
    }
    return filteredOptions.map((option)=>renderOption(option));
}
