'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useListboxContextValues", {
    enumerable: true,
    get: function() {
        return useListboxContextValues;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactcontextselector = require("@fluentui/react-context-selector");
const _ListboxContext = require("./ListboxContext");
function useListboxContextValues(state) {
    const hasListboxContext = (0, _reactcontextselector.useHasParentContext)(_ListboxContext.ListboxContext);
    const { getOptionById, getOptionsMatchingValue, multiselect, registerOption, selectedOptions, selectOption, activeDescendantController } = state;
    // get register/unregister functions from parent combobox context
    const parentRegisterOption = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.registerOption);
    const onOptionClick = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.onOptionClick);
    const onActiveDescendantChange = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.onActiveDescendantChange);
    const registerOptionValue = hasListboxContext ? parentRegisterOption : registerOption;
    const listbox = {
        activeOption: undefined,
        focusVisible: false,
        getOptionById,
        getOptionsMatchingValue,
        multiselect,
        registerOption: registerOptionValue,
        selectedOptions,
        selectOption,
        setActiveOption: ()=>undefined,
        onOptionClick,
        onActiveDescendantChange
    };
    const activeDescendant = _react.useMemo(()=>({
            controller: activeDescendantController
        }), [
        activeDescendantController
    ]);
    return {
        listbox,
        activeDescendant
    };
}
