'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useComboboxContextValues", {
    enumerable: true,
    get: function() {
        return useComboboxContextValues;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
function useComboboxContextValues(state) {
    const { appearance, open, getOptionById, getOptionsMatchingValue, registerOption, selectedOptions, selectOption, setOpen, size, activeDescendantController, onOptionClick, onActiveDescendantChange } = state;
    const combobox = {
        activeOption: undefined,
        appearance,
        focusVisible: false,
        open,
        registerOption,
        selectedOptions,
        selectOption,
        setActiveOption: ()=>null,
        setOpen,
        size
    };
    const listbox = {
        activeOption: undefined,
        focusVisible: false,
        getOptionById,
        getOptionsMatchingValue,
        registerOption,
        selectedOptions,
        selectOption,
        setActiveOption: ()=>null,
        onOptionClick,
        onActiveDescendantChange
    };
    const activeDescendant = _react.useMemo(()=>({
            controller: activeDescendantController
        }), [
        activeDescendantController
    ]);
    return {
        combobox,
        activeDescendant,
        listbox
    };
}
