'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    optionGroupClassNames: function() {
        return optionGroupClassNames;
    },
    useOptionGroupStyles_unstable: function() {
        return useOptionGroupStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const optionGroupClassNames = {
    root: 'fui-OptionGroup',
    label: 'fui-OptionGroup__label'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'column',
        rowGap: _reacttheme.tokens.spacingHorizontalXXS,
        '&:not(:last-child)::after': {
            content: '""',
            borderBottom: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke2}`,
            display: 'block',
            paddingBottom: _reacttheme.tokens.spacingHorizontalXS,
            margin: `0 ${`calc(${_reacttheme.tokens.spacingHorizontalXS} * -1)`} ${_reacttheme.tokens.spacingVerticalXS}`
        }
    },
    label: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        color: _reacttheme.tokens.colorNeutralForeground3,
        display: 'block',
        fontSize: _reacttheme.tokens.fontSizeBase200,
        fontWeight: _reacttheme.tokens.fontWeightSemibold,
        lineHeight: _reacttheme.tokens.lineHeightBase200,
        padding: `${_reacttheme.tokens.spacingHorizontalS} ${_reacttheme.tokens.spacingHorizontalSNudge}`
    }
});
const useOptionGroupStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(optionGroupClassNames.root, styles.root, state.root.className);
    if (state.label) {
        state.label.className = (0, _react.mergeClasses)(optionGroupClassNames.label, styles.label, state.label.className);
    }
    return state;
};
