'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    optionClassNames: function() {
        return optionClassNames;
    },
    useOptionStyles_unstable: function() {
        return useOptionStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _reactaria = require("@fluentui/react-aria");
const _react = require("@griffel/react");
const optionClassNames = {
    root: 'fui-Option',
    checkIcon: 'fui-Option__checkIcon'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        alignItems: 'center',
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        color: _reacttheme.tokens.colorNeutralForeground1,
        columnGap: _reacttheme.tokens.spacingHorizontalXS,
        cursor: 'pointer',
        display: 'flex',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        fontSize: _reacttheme.tokens.fontSizeBase300,
        lineHeight: _reacttheme.tokens.lineHeightBase300,
        padding: `${_reacttheme.tokens.spacingVerticalSNudge} ${_reacttheme.tokens.spacingHorizontalS}`,
        position: 'relative',
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1Hover,
            color: _reacttheme.tokens.colorNeutralForeground1Hover,
            [`& .${optionClassNames.checkIcon}`]: _react.shorthands.borderColor(_reacttheme.tokens.colorNeutralForeground1Hover)
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1Pressed,
            color: _reacttheme.tokens.colorNeutralForeground1Pressed,
            [`& .${optionClassNames.checkIcon}`]: _react.shorthands.borderColor(_reacttheme.tokens.colorNeutralForeground1Hover)
        }
    },
    active: {
        [`[${_reactaria.ACTIVEDESCENDANT_FOCUSVISIBLE_ATTRIBUTE}]::after`]: {
            content: '""',
            position: 'absolute',
            pointerEvents: 'none',
            zIndex: 1,
            border: `2px solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            top: '-2px',
            bottom: '-2px',
            left: '-2px',
            right: '-2px'
        }
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        ':hover': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground,
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            [`& .${optionClassNames.checkIcon}`]: _react.shorthands.borderColor(_reacttheme.tokens.colorNeutralForegroundDisabled)
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground,
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            [`& .${optionClassNames.checkIcon}`]: _react.shorthands.borderColor(_reacttheme.tokens.colorNeutralForegroundDisabled)
        },
        '@media (forced-colors: active)': {
            color: 'GrayText'
        }
    },
    selected: {},
    checkIcon: {
        flexShrink: 0,
        fontSize: _reacttheme.tokens.fontSizeBase400,
        // Shift icon(s) to the left to give text content extra spacing without needing an extra node
        // This is done instead of gap since the extra space only exists between icon > content, not icon > icon
        marginLeft: `calc(${_reacttheme.tokens.spacingHorizontalXXS} * -1)`,
        marginRight: _reacttheme.tokens.spacingHorizontalXXS,
        visibility: 'hidden',
        '& svg': {
            display: 'block'
        }
    },
    selectedCheck: {
        visibility: 'visible'
    },
    multiselectCheck: {
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStrokeAccessible}`,
        borderRadius: _reacttheme.tokens.borderRadiusSmall,
        boxSizing: 'border-box',
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center',
        fill: 'currentColor',
        fontSize: '12px',
        height: '16px',
        width: '16px',
        visibility: 'visible'
    },
    selectedMultiselectCheck: {
        backgroundColor: _reacttheme.tokens.colorCompoundBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundInverted,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorCompoundBrandBackground)
    },
    checkDisabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        '@media (forced-colors: active)': {
            color: 'GrayText'
        }
    },
    multiselectCheckDisabled: _react.shorthands.borderColor(_reacttheme.tokens.colorNeutralForegroundDisabled)
});
const useOptionStyles_unstable = (state)=>{
    'use no memo';
    const { disabled, multiselect, selected } = state;
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(optionClassNames.root, styles.root, styles.active, disabled && styles.disabled, selected && styles.selected, state.root.className);
    if (state.checkIcon) {
        state.checkIcon.className = (0, _react.mergeClasses)(optionClassNames.checkIcon, styles.checkIcon, multiselect && styles.multiselectCheck, selected && styles.selectedCheck, selected && multiselect && styles.selectedMultiselectCheck, disabled && styles.checkDisabled, disabled && multiselect && styles.multiselectCheckDisabled, state.checkIcon.className);
    }
    return state;
};
