'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useOption_unstable", {
    enumerable: true,
    get: function() {
        return useOption_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactaria = require("@fluentui/react-aria");
const _reacticons = require("@fluentui/react-icons");
const _ListboxContext = require("../../contexts/ListboxContext");
function getTextString(text, children) {
    if (text !== undefined) {
        return text;
    }
    let textString = '';
    let hasNonStringChild = false;
    _react.Children.forEach(children, (child)=>{
        if (typeof child === 'string') {
            textString += child;
        } else {
            hasNonStringChild = true;
        }
    });
    // warn if an Option has non-string children and no text prop
    if (hasNonStringChild) {
        // eslint-disable-next-line no-console
        console.warn('Provide a `text` prop to Option components when they contain non-string children.');
    }
    return textString;
}
const useOption_unstable = (props, ref)=>{
    const { children, disabled, text, value } = props;
    const optionRef = _react.useRef(null);
    const optionText = getTextString(text, children);
    const optionValue = value !== null && value !== void 0 ? value : optionText;
    // use the id if provided, otherwise use a generated id
    const id = (0, _reactutilities.useId)('fluent-option', props.id);
    // data used for context registration & events
    const optionData = _react.useMemo(()=>({
            id,
            disabled,
            text: optionText,
            value: optionValue
        }), [
        id,
        disabled,
        optionText,
        optionValue
    ]);
    // context values
    const { controller: activeDescendantController } = (0, _reactaria.useActiveDescendantContext)();
    const multiselect = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.multiselect);
    const registerOption = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.registerOption);
    const selected = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>{
        const selectedOptions = ctx.selectedOptions;
        return optionValue !== undefined && selectedOptions.find((o)=>o === optionValue) !== undefined;
    });
    const selectOption = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.selectOption);
    const onOptionClick = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.onOptionClick);
    // check icon
    let CheckIcon = /*#__PURE__*/ _react.createElement(_reacticons.CheckmarkFilled, null);
    if (multiselect) {
        CheckIcon = selected ? /*#__PURE__*/ _react.createElement(_reacticons.Checkmark12Filled, null) : '';
    }
    const onClick = (event)=>{
        var _props_onClick;
        if (disabled) {
            event.preventDefault();
            return;
        }
        activeDescendantController.focus(id);
        // handle selection change
        selectOption(event, optionData);
        onOptionClick(event);
        (_props_onClick = props.onClick) === null || _props_onClick === void 0 ? void 0 : _props_onClick.call(props, event);
    };
    // register option data with context
    _react.useEffect(()=>{
        if (id && optionRef.current) {
            return registerOption(optionData, optionRef.current);
        }
    }, [
        id,
        optionData,
        registerOption
    ]);
    const semanticProps = multiselect ? {
        role: 'menuitemcheckbox',
        'aria-checked': selected
    } : {
        role: 'option',
        'aria-selected': selected
    };
    return {
        components: {
            root: 'div',
            checkIcon: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, optionRef),
            'aria-disabled': disabled ? 'true' : undefined,
            id,
            ...semanticProps,
            ...props,
            onClick
        }), {
            elementType: 'div'
        }),
        checkIcon: _reactutilities.slot.optional(props.checkIcon, {
            renderByDefault: true,
            defaultProps: {
                'aria-hidden': 'true',
                children: CheckIcon
            },
            elementType: 'span'
        }),
        disabled,
        multiselect,
        selected,
        // no longer used
        focusVisible: false,
        active: false
    };
};
