'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    listboxClassNames: function() {
        return listboxClassNames;
    },
    useListboxStyles_unstable: function() {
        return useListboxStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const listboxClassNames = {
    root: 'fui-Listbox'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        boxSizing: 'border-box',
        display: 'flex',
        flexDirection: 'column',
        minWidth: '160px',
        overflowY: 'auto',
        outline: `1px solid ${_reacttheme.tokens.colorTransparentStroke}`,
        padding: _reacttheme.tokens.spacingHorizontalXS,
        rowGap: _reacttheme.tokens.spacingHorizontalXXS
    }
});
const useListboxStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(listboxClassNames.root, styles.root, state.root.className);
    return state;
};
