'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useListbox_unstable", {
    enumerable: true,
    get: function() {
        return useListbox_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reactcontextselector = require("@fluentui/react-context-selector");
const _reactaria = require("@fluentui/react-aria");
const _dropdownKeyActions = require("../../utils/dropdownKeyActions");
const _useOptionCollection = require("../../utils/useOptionCollection");
const _useSelection = require("../../utils/useSelection");
const _useOptionStylesstyles = require("../Option/useOptionStyles.styles");
const _ListboxContext = require("../../contexts/ListboxContext");
const _reacttabster = require("@fluentui/react-tabster");
// eslint-disable-next-line @typescript-eslint/naming-convention
const UNSAFE_noLongerUsed = {
    activeOption: undefined,
    focusVisible: false,
    setActiveOption: ()=>null
};
const useListbox_unstable = (props, ref)=>{
    'use no memo';
    const { multiselect, disableAutoFocus = false } = props;
    const optionCollection = (0, _useOptionCollection.useOptionCollection)();
    const { listboxRef: activeDescendantListboxRef, activeParentRef, controller } = (0, _reactaria.useActiveDescendant)({
        matchOption: (el)=>el.classList.contains(_useOptionStylesstyles.optionClassNames.root)
    });
    const hasListboxContext = (0, _reactcontextselector.useHasParentContext)(_ListboxContext.ListboxContext);
    const onActiveDescendantChange = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.onActiveDescendantChange);
    const contextGetOptionById = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.getOptionById);
    const contextGetOptionsMatchingValue = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.getOptionsMatchingValue);
    const getOptionById = hasListboxContext ? contextGetOptionById : optionCollection.getOptionById;
    const getOptionsMatchingValue = hasListboxContext ? contextGetOptionsMatchingValue : optionCollection.getOptionsMatchingValue;
    const listenerRef = _react.useMemo(()=>{
        let element = null;
        const listener = (untypedEvent)=>{
            // Typescript doesn't support custom event types on handler
            const event = untypedEvent;
            onActiveDescendantChange === null || onActiveDescendantChange === void 0 ? void 0 : onActiveDescendantChange(event);
        };
        return (el)=>{
            if (!el) {
                element === null || element === void 0 ? void 0 : element.removeEventListener('activedescendantchange', listener);
                return;
            }
            element = el;
            element.addEventListener('activedescendantchange', listener);
        };
    }, [
        onActiveDescendantChange
    ]);
    const [isNavigatingWithKeyboard, setIsNavigatingWithKeyboard] = _react.useState(false);
    (0, _reacttabster.useOnKeyboardNavigationChange)(setIsNavigatingWithKeyboard);
    const activeDescendantContext = (0, _reactaria.useActiveDescendantContext)();
    const hasParentActiveDescendantContext = (0, _reactaria.useHasParentActiveDescendantContext)();
    const activeDescendantController = hasParentActiveDescendantContext ? activeDescendantContext.controller : controller;
    const { clearSelection, selectedOptions, selectOption } = (0, _useSelection.useSelection)(props);
    const onKeyDown = (event)=>{
        const action = (0, _dropdownKeyActions.getDropdownActionFromKey)(event, {
            open: true
        });
        const activeOptionId = activeDescendantController.active();
        const activeOption = activeOptionId ? getOptionById(activeOptionId) : null;
        switch(action){
            case 'First':
            case 'Last':
            case 'Next':
            case 'Previous':
            case 'PageDown':
            case 'PageUp':
            case 'CloseSelect':
            case 'Select':
                event.preventDefault();
                break;
        }
        switch(action){
            case 'Next':
                if (activeOption) {
                    activeDescendantController.next();
                } else {
                    activeDescendantController.first();
                }
                break;
            case 'Previous':
                if (activeOption) {
                    activeDescendantController.prev();
                } else {
                    activeDescendantController.first();
                }
                break;
            case 'PageUp':
            case 'First':
                activeDescendantController.first();
                break;
            case 'PageDown':
            case 'Last':
                activeDescendantController.last();
                break;
            case 'Select':
            case 'CloseSelect':
                activeOption && selectOption(event, activeOption);
                break;
        }
    };
    // get state from parent combobox, if it exists
    const contextSelectedOptions = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.selectedOptions);
    const contextSelectOption = (0, _ListboxContext.useListboxContext_unstable)((ctx)=>ctx.selectOption);
    // without a parent combobox context, provide values directly from Listbox
    const optionContextValues = hasListboxContext ? {
        selectedOptions: contextSelectedOptions,
        selectOption: contextSelectOption,
        ...UNSAFE_noLongerUsed
    } : {
        selectedOptions,
        selectOption,
        ...UNSAFE_noLongerUsed
    };
    _react.useEffect(()=>{
        // if the listbox has a parent context, that parent context should handle the activedescendant
        if (hasParentActiveDescendantContext) {
            return;
        }
        // disable focus-visible attributes until focus is received
        activeDescendantController.hideFocusVisibleAttributes();
        if (!disableAutoFocus) {
            // if it is single-select and there is a selected option, start at the selected option
            if (!multiselect && optionContextValues.selectedOptions.length > 0) {
                const selectedOption = getOptionsMatchingValue((v)=>v === optionContextValues.selectedOptions[0]).pop();
                if (selectedOption === null || selectedOption === void 0 ? void 0 : selectedOption.id) {
                    activeDescendantController.focus(selectedOption.id);
                }
            } else {
                activeDescendantController.first();
            }
        }
        return ()=>{
            activeDescendantController.blur();
        };
    // this should only be run once in the lifecycle of the Listbox
    // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    const onFocus = _react.useCallback(()=>{
        if (hasParentActiveDescendantContext) {
            return;
        }
        activeDescendantController.showFocusVisibleAttributes();
        if (isNavigatingWithKeyboard) {
            activeDescendantController.scrollActiveIntoView();
        }
    }, [
        activeDescendantController,
        hasParentActiveDescendantContext,
        isNavigatingWithKeyboard
    ]);
    const onBlur = _react.useCallback(()=>{
        if (hasParentActiveDescendantContext) {
            return;
        }
        activeDescendantController.hideFocusVisibleAttributes();
    }, [
        activeDescendantController,
        hasParentActiveDescendantContext
    ]);
    const state = {
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, activeParentRef, activeDescendantListboxRef, listenerRef),
            role: multiselect ? 'menu' : 'listbox',
            tabIndex: 0,
            ...props
        }), {
            elementType: 'div'
        }),
        standalone: !hasListboxContext,
        multiselect,
        clearSelection,
        activeDescendantController,
        onActiveDescendantChange,
        ...optionCollection,
        ...optionContextValues
    };
    state.root.onKeyDown = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.root.onKeyDown, onKeyDown));
    state.root.onFocus = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.root.onFocus, onFocus));
    state.root.onBlur = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.root.onBlur, onBlur));
    return state;
};
