'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dropdownClassNames: function() {
        return dropdownClassNames;
    },
    useDropdownStyles_unstable: function() {
        return useDropdownStyles_unstable;
    }
});
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const _internalTokens = require("../../utils/internalTokens");
const dropdownClassNames = {
    root: 'fui-Dropdown',
    button: 'fui-Dropdown__button',
    clearButton: 'fui-Dropdown__clearButton',
    expandIcon: 'fui-Dropdown__expandIcon',
    listbox: 'fui-Dropdown__listbox'
};
/**
 * Styles for Dropdown
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        boxSizing: 'border-box',
        display: 'inline-flex',
        minWidth: '250px',
        position: 'relative',
        verticalAlign: 'middle',
        // windows high contrast mode focus indicator
        ':focus-within': {
            outlineWidth: '2px',
            outlineStyle: 'solid',
            outlineColor: 'transparent'
        },
        // bottom focus border, shared with Input, Select, and SpinButton
        '::after': {
            boxSizing: 'border-box',
            content: '""',
            position: 'absolute',
            left: '-1px',
            bottom: '-1px',
            right: '-1px',
            height: `max(${_reacttheme.tokens.strokeWidthThick}, ${_reacttheme.tokens.borderRadiusMedium})`,
            borderBottomLeftRadius: _reacttheme.tokens.borderRadiusMedium,
            borderBottomRightRadius: _reacttheme.tokens.borderRadiusMedium,
            borderBottom: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorCompoundBrandStroke}`,
            clipPath: 'inset(calc(100% - 2px) 0 0 0)',
            transform: 'scaleX(0)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationUltraFast,
            transitionDelay: _reacttheme.tokens.curveAccelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within::after': {
            transform: 'scaleX(1)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationNormal,
            transitionDelay: _reacttheme.tokens.curveDecelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within:active::after': {
            borderBottomColor: _reacttheme.tokens.colorCompoundBrandStrokePressed
        },
        '@supports selector(:has(*))': {
            [`:has(.${dropdownClassNames.clearButton}:focus)::after`]: {
                borderBottomColor: 'initial',
                transform: 'scaleX(0)'
            }
        }
    },
    listbox: {
        boxSizing: 'border-box',
        boxShadow: `${_reacttheme.tokens.shadow16}`,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        maxHeight: '80vh'
    },
    listboxCollapsed: {
        display: 'none'
    },
    // When rendering inline, the popupSurface will be rendered under relatively positioned elements such as Input.
    // This is due to the surface being positioned as absolute, therefore zIndex: 1 ensures that won't happen.
    inlineListbox: {
        zIndex: 1
    },
    button: {
        alignItems: 'center',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        border: 'none',
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralForeground1,
        columnGap: _reacttheme.tokens.spacingHorizontalXXS,
        cursor: 'pointer',
        display: 'grid',
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        gridTemplateColumns: '[content] 1fr [icon] auto [end]',
        justifyContent: 'space-between',
        textAlign: 'left',
        width: '100%',
        '&:focus': {
            outlineStyle: 'none'
        }
    },
    placeholder: {
        color: _reacttheme.tokens.colorNeutralForeground4
    },
    // size variants
    small: {
        ..._reacttheme.typographyStyles.caption1,
        padding: `3px ${_reacttheme.tokens.spacingHorizontalSNudge} 3px ${`calc(${_reacttheme.tokens.spacingHorizontalSNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`}`
    },
    medium: {
        ..._reacttheme.typographyStyles.body1,
        padding: `5px ${_reacttheme.tokens.spacingHorizontalMNudge} 5px ${`calc(${_reacttheme.tokens.spacingHorizontalMNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`}`
    },
    large: {
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge,
        ..._reacttheme.typographyStyles.body2,
        padding: `7px ${_reacttheme.tokens.spacingHorizontalM} 7px ${`calc(${_reacttheme.tokens.spacingHorizontalM} + ${_reacttheme.tokens.spacingHorizontalSNudge})`}`
    },
    // appearance variants
    outline: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1}`,
        borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
    },
    outlineInteractive: {
        '&:hover': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
        },
        '&:active': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        },
        '&:focus-within': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        }
    },
    underline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        borderBottom: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStrokeAccessible}`,
        borderRadius: '0'
    },
    'filled-lighter': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid transparent`
    },
    'filled-darker': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        border: `${_reacttheme.tokens.strokeWidthThin} solid transparent`
    },
    invalid: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
        }
    },
    invalidUnderline: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            borderBottomColor: _reacttheme.tokens.colorPaletteRedBorder2
        }
    },
    disabled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('GrayText')
        }
    },
    disabledText: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed'
    },
    hidden: {
        display: 'none'
    }
});
const useIconStyles = (0, _react.makeStyles)({
    icon: {
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralStrokeAccessible,
        display: 'block',
        fontSize: _reacttheme.tokens.fontSizeBase500,
        gridColumnStart: 'icon',
        gridColumnEnd: 'end',
        // the SVG must have display: block for accurate positioning
        // otherwise an extra inline space is inserted after the svg element
        '& svg': {
            display: 'block'
        }
    },
    // icon size variants
    small: {
        fontSize: _internalTokens.iconSizes.small,
        marginLeft: _reacttheme.tokens.spacingHorizontalXXS
    },
    medium: {
        fontSize: _internalTokens.iconSizes.medium,
        marginLeft: _reacttheme.tokens.spacingHorizontalXXS
    },
    large: {
        fontSize: _internalTokens.iconSizes.large,
        marginLeft: _reacttheme.tokens.spacingHorizontalSNudge
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    }
});
const useBaseClearButtonStyle = (0, _react.makeResetStyles)({
    alignSelf: 'center',
    backgroundColor: _reacttheme.tokens.colorTransparentBackground,
    border: 'none',
    cursor: 'pointer',
    height: 'fit-content',
    margin: 0,
    marginRight: _reacttheme.tokens.spacingHorizontalMNudge,
    padding: 0,
    position: 'relative',
    ...(0, _reacttabster.createFocusOutlineStyle)()
});
const useDropdownStyles_unstable = (state)=>{
    'use no memo';
    const { appearance, open, placeholderVisible, showClearButton, size } = state;
    const invalid = `${state.button['aria-invalid']}` === 'true';
    const disabled = state.button.disabled;
    const styles = useStyles();
    const iconStyles = useIconStyles();
    const clearButtonStyle = useBaseClearButtonStyle();
    state.root.className = (0, _react.mergeClasses)(dropdownClassNames.root, styles.root, styles[appearance], !disabled && appearance === 'outline' && styles.outlineInteractive, invalid && appearance !== 'underline' && styles.invalid, invalid && appearance === 'underline' && styles.invalidUnderline, disabled && styles.disabled, state.root.className);
    state.button.className = (0, _react.mergeClasses)(dropdownClassNames.button, styles.button, styles[size], placeholderVisible && styles.placeholder, disabled && styles.disabledText, state.button.className);
    if (state.listbox) {
        state.listbox.className = (0, _react.mergeClasses)(dropdownClassNames.listbox, styles.listbox, state.inlinePopup && styles.inlineListbox, !open && styles.listboxCollapsed, state.listbox.className);
    }
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(dropdownClassNames.expandIcon, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, showClearButton && styles.hidden, state.expandIcon.className);
    }
    if (state.clearButton) {
        state.clearButton.className = (0, _react.mergeClasses)(dropdownClassNames.clearButton, clearButtonStyle, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, !showClearButton && styles.hidden, state.clearButton.className);
    }
    return state;
};
