'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    dropdownClassNames: function() {
        return dropdownClassNames;
    },
    useDropdownStyles_unstable: function() {
        return useDropdownStyles_unstable;
    }
});
const _react = require("@griffel/react");
const dropdownClassNames = {
    root: 'fui-Dropdown',
    button: 'fui-Dropdown__button',
    clearButton: 'fui-Dropdown__clearButton',
    expandIcon: 'fui-Dropdown__expandIcon',
    listbox: 'fui-Dropdown__listbox'
};
/**
 * Styles for Dropdown
 */ const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "ft85np5",
        B7ck84d: "f1ewtqcl",
        mc9l5x: "ftuwxu6",
        Bf4jedk: "f1exfvgq",
        qhf8xq: "f10pi13n",
        ha4doy: "fmrv4ls",
        Bbr2w1p: "f14a1fxs",
        Bduesf4: "f3e99gv",
        Bpq79vn: "fhljsf7",
        li1rpt: "f1gw3sf2",
        Bsft5z2: "f13zj6fq",
        E3zdtr: "f1mdlcz9",
        Eqx8gd: [
            "f1a7op3",
            "f1cjjd47"
        ],
        By385i5: "f1gboi2j",
        B1piin3: [
            "f1cjjd47",
            "f1a7op3"
        ],
        Dlnsje: "ffyw7fx",
        d9w3h3: [
            "f1kp91vd",
            "f1ibwz09"
        ],
        B3778ie: [
            "f1ibwz09",
            "f1kp91vd"
        ],
        B1q35kw: 0,
        Bw17bha: 0,
        Bcgy8vk: 0,
        Bjuhk93: "f1mnjydx",
        Gjdm7m: "f13evtba",
        b1kco5: "f1yk9hq",
        Ba2ppi3: "fhwpy7i",
        F2fol1: "f14ee0xe",
        lck23g: "f1xhbsuh",
        df92cz: "fv8e3ye",
        I188md: "ftb5wc6",
        umuwi5: "fjw5xc1",
        Blcqepd: "f1xdyd5c",
        nplu4u: "fatpbeo",
        Bioka5o: "fb7uyps",
        H713fs: "f1cmft4k",
        B9ooomg: "f1x58t8o",
        Bercvud: "f1ibeo51",
        Bz04dq9: "f132nw8t",
        Budl3uf: "f1htdosj"
    },
    listbox: {
        B7ck84d: "f1ewtqcl",
        E5pizo: "f1hg901r",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "ft85np5",
        Bxyxcbc: "fmmk62d"
    },
    listboxCollapsed: {
        mc9l5x: "fjseox"
    },
    inlineListbox: {
        Bj3rh1h: "f19g0ac"
    },
    button: {
        Bt984gj: "f122n59",
        De3pzq: "f1c21dwh",
        Bgfg5da: 0,
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "f3bhgqh",
        B7ck84d: "f1ewtqcl",
        sj55zd: "f19n0e5",
        i8kkvl: "f14mj54c",
        Bceei9c: "f1k6fduh",
        mc9l5x: "f13qh94s",
        Bahqtrf: "fk6fouc",
        Budl1dq: "f12nh0o2",
        Brf1p80: "f1869bpl",
        fsow6f: [
            "f1o700av",
            "fes3tcz"
        ],
        a9b677: "fly5x3f",
        Brovlpu: "ftqa4ok"
    },
    placeholder: {
        sj55zd: "fxc4j92"
    },
    small: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fy9rknc",
        Bhrd7zp: "figsok6",
        Bg96gwp: "fwrc4pm",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "fye6m5k",
            "f3cq2dl"
        ]
    },
    medium: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fkhj508",
        Bhrd7zp: "figsok6",
        Bg96gwp: "f1i3iumi",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "f14ev680",
            "f58uxzw"
        ]
    },
    large: {
        i8kkvl: "f1rjii52",
        Bahqtrf: "fk6fouc",
        Be2twd7: "fod5ikn",
        Bhrd7zp: "figsok6",
        Bg96gwp: "faaz57k",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "f139mn7i",
            "f1v3q0m"
        ]
    },
    outline: {
        De3pzq: "fxugw4r",
        Bgfg5da: 0,
        B9xav0g: "f1c1zstj",
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "fhz96rm"
    },
    outlineInteractive: {
        Bgoe8wy: "fvcxoqz",
        Bwzppfd: [
            "f1ub3y4t",
            "f1m52nbi"
        ],
        oetu4i: "f1l4zc64",
        gg5e9n: [
            "f1m52nbi",
            "f1ub3y4t"
        ],
        B6oc9vd: "fvs00aa",
        ak43y8: [
            "f1assf6x",
            "f4ruux4"
        ],
        wmxk5l: "f1z0osm6",
        B50zh58: [
            "f4ruux4",
            "f1assf6x"
        ],
        Bvq3b66: "f1b473iu",
        Brahy3i: [
            "f381qr8",
            "ft4skwv"
        ],
        zoxjo1: "f1qzcrsd",
        an54nd: [
            "ft4skwv",
            "f381qr8"
        ]
    },
    underline: {
        De3pzq: "f1c21dwh",
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        Bgfg5da: "f9ez7ne",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "fokr779"
    },
    "filled-lighter": {
        De3pzq: "fxugw4r",
        Bgfg5da: 0,
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "fs2rfia"
    },
    "filled-darker": {
        De3pzq: "f16xq7d1",
        Bgfg5da: 0,
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "fs2rfia"
    },
    invalid: {
        tvckwq: "fs4k3qj",
        gk2u95: [
            "fcee079",
            "fmyw78r"
        ],
        hhx65j: "f1fgmyf4",
        Bxowmz0: [
            "fmyw78r",
            "fcee079"
        ]
    },
    invalidUnderline: {
        hhx65j: "f1fgmyf4"
    },
    disabled: {
        Bceei9c: "fdrzuqr",
        De3pzq: "f1c21dwh",
        g2u3we: "f1jj8ep1",
        h3c5rm: [
            "f15xbau",
            "fy0fskl"
        ],
        B9xav0g: "f4ikngz",
        zhjwy3: [
            "fy0fskl",
            "f15xbau"
        ],
        Bjwas2f: "fg455y9",
        Bn1d65q: [
            "f1rvyvqg",
            "f14g86mu"
        ],
        Bxeuatn: "f1cwzwz",
        n51gp8: [
            "f14g86mu",
            "f1rvyvqg"
        ]
    },
    disabledText: {
        sj55zd: "f1s2aq7o",
        Bceei9c: "fdrzuqr"
    },
    hidden: {
        mc9l5x: "fjseox"
    }
}, {
    d: [
        [
            ".ft85np5{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".f1ewtqcl{box-sizing:border-box;}",
        ".ftuwxu6{display:inline-flex;}",
        ".f1exfvgq{min-width:250px;}",
        ".f10pi13n{position:relative;}",
        ".fmrv4ls{vertical-align:middle;}",
        ".f1gw3sf2::after{box-sizing:border-box;}",
        ".f13zj6fq::after{content:\"\";}",
        ".f1mdlcz9::after{position:absolute;}",
        ".f1a7op3::after{left:-1px;}",
        ".f1cjjd47::after{right:-1px;}",
        ".f1gboi2j::after{bottom:-1px;}",
        ".ffyw7fx::after{height:max(var(--strokeWidthThick), var(--borderRadiusMedium));}",
        ".f1kp91vd::after{border-bottom-left-radius:var(--borderRadiusMedium);}",
        ".f1ibwz09::after{border-bottom-right-radius:var(--borderRadiusMedium);}",
        [
            ".f1mnjydx::after{border-bottom:var(--strokeWidthThick) solid var(--colorCompoundBrandStroke);}",
            {
                p: -1
            }
        ],
        ".f13evtba::after{clip-path:inset(calc(100% - 2px) 0 0 0);}",
        ".f1yk9hq::after{transform:scaleX(0);}",
        ".fhwpy7i::after{transition-property:transform;}",
        ".f14ee0xe::after{transition-duration:var(--durationUltraFast);}",
        ".f1xhbsuh::after{transition-delay:var(--curveAccelerateMid);}",
        ".f1hg901r{box-shadow:var(--shadow16);}",
        [
            ".ft85np5{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".fmmk62d{max-height:80vh;}",
        ".fjseox{display:none;}",
        ".f19g0ac{z-index:1;}",
        ".f122n59{align-items:center;}",
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}",
        [
            ".f3bhgqh{border:none;}",
            {
                p: -2
            }
        ],
        ".f19n0e5{color:var(--colorNeutralForeground1);}",
        ".f14mj54c{column-gap:var(--spacingHorizontalXXS);}",
        ".f1k6fduh{cursor:pointer;}",
        ".f13qh94s{display:grid;}",
        ".fk6fouc{font-family:var(--fontFamilyBase);}",
        ".f12nh0o2{grid-template-columns:[content] 1fr [icon] auto [end];}",
        ".f1869bpl{justify-content:space-between;}",
        ".f1o700av{text-align:left;}",
        ".fes3tcz{text-align:right;}",
        ".fly5x3f{width:100%;}",
        ".fxc4j92{color:var(--colorNeutralForeground4);}",
        ".fy9rknc{font-size:var(--fontSizeBase200);}",
        ".figsok6{font-weight:var(--fontWeightRegular);}",
        ".fwrc4pm{line-height:var(--lineHeightBase200);}",
        [
            ".fye6m5k{padding:3px var(--spacingHorizontalSNudge) 3px calc(var(--spacingHorizontalSNudge) + var(--spacingHorizontalXXS));}",
            {
                p: -1
            }
        ],
        [
            ".f3cq2dl{padding:3px calc(var(--spacingHorizontalSNudge) + var(--spacingHorizontalXXS)) 3px var(--spacingHorizontalSNudge);}",
            {
                p: -1
            }
        ],
        ".fkhj508{font-size:var(--fontSizeBase300);}",
        ".f1i3iumi{line-height:var(--lineHeightBase300);}",
        [
            ".f14ev680{padding:5px var(--spacingHorizontalMNudge) 5px calc(var(--spacingHorizontalMNudge) + var(--spacingHorizontalXXS));}",
            {
                p: -1
            }
        ],
        [
            ".f58uxzw{padding:5px calc(var(--spacingHorizontalMNudge) + var(--spacingHorizontalXXS)) 5px var(--spacingHorizontalMNudge);}",
            {
                p: -1
            }
        ],
        ".f1rjii52{column-gap:var(--spacingHorizontalSNudge);}",
        ".fod5ikn{font-size:var(--fontSizeBase400);}",
        ".faaz57k{line-height:var(--lineHeightBase400);}",
        [
            ".f139mn7i{padding:7px var(--spacingHorizontalM) 7px calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge));}",
            {
                p: -1
            }
        ],
        [
            ".f1v3q0m{padding:7px calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge)) 7px var(--spacingHorizontalM);}",
            {
                p: -1
            }
        ],
        ".fxugw4r{background-color:var(--colorNeutralBackground1);}",
        [
            ".fhz96rm{border:var(--strokeWidthThin) solid var(--colorNeutralStroke1);}",
            {
                p: -2
            }
        ],
        ".f1c1zstj{border-bottom-color:var(--colorNeutralStrokeAccessible);}",
        [
            ".f9ez7ne{border-bottom:var(--strokeWidthThin) solid var(--colorNeutralStrokeAccessible);}",
            {
                p: -1
            }
        ],
        [
            ".fokr779{border-radius:0;}",
            {
                p: -1
            }
        ],
        [
            ".fs2rfia{border:var(--strokeWidthThin) solid transparent;}",
            {
                p: -2
            }
        ],
        ".f16xq7d1{background-color:var(--colorNeutralBackground3);}",
        [
            ".fs2rfia{border:var(--strokeWidthThin) solid transparent;}",
            {
                p: -2
            }
        ],
        ".fs4k3qj:not(:focus-within),.fs4k3qj:hover:not(:focus-within){border-top-color:var(--colorPaletteRedBorder2);}",
        ".fcee079:not(:focus-within),.fcee079:hover:not(:focus-within){border-right-color:var(--colorPaletteRedBorder2);}",
        ".fmyw78r:not(:focus-within),.fmyw78r:hover:not(:focus-within){border-left-color:var(--colorPaletteRedBorder2);}",
        ".f1fgmyf4:not(:focus-within),.f1fgmyf4:hover:not(:focus-within){border-bottom-color:var(--colorPaletteRedBorder2);}",
        ".fdrzuqr{cursor:not-allowed;}",
        ".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}",
        ".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}",
        ".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}",
        ".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}",
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}"
    ],
    w: [
        ".f14a1fxs:focus-within{outline-width:2px;}",
        ".f3e99gv:focus-within{outline-style:solid;}",
        ".fhljsf7:focus-within{outline-color:transparent;}",
        ".fjw5xc1:focus-within::after{transform:scaleX(1);}",
        ".f1xdyd5c:focus-within::after{transition-property:transform;}",
        ".fatpbeo:focus-within::after{transition-duration:var(--durationNormal);}",
        ".fb7uyps:focus-within::after{transition-delay:var(--curveDecelerateMid);}",
        ".f1ibeo51:focus-within:active::after{border-bottom-color:var(--colorCompoundBrandStrokePressed);}",
        ".f1b473iu:focus-within{border-top-color:var(--colorNeutralStroke1Pressed);}",
        ".f381qr8:focus-within{border-right-color:var(--colorNeutralStroke1Pressed);}",
        ".ft4skwv:focus-within{border-left-color:var(--colorNeutralStroke1Pressed);}",
        ".f1qzcrsd:focus-within{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"
    ],
    m: [
        [
            "@media screen and (prefers-reduced-motion: reduce){.fv8e3ye::after{transition-duration:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (prefers-reduced-motion: reduce){.ftb5wc6::after{transition-delay:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (prefers-reduced-motion: reduce){.f1cmft4k:focus-within::after{transition-duration:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (prefers-reduced-motion: reduce){.f1x58t8o:focus-within::after{transition-delay:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media (forced-colors: active){.fg455y9{border-top-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f14g86mu{border-left-color:GrayText;}.f1rvyvqg{border-right-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1cwzwz{border-bottom-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ],
    t: [
        "@supports selector(:has(*)){.f132nw8t:has(.fui-Dropdown__clearButton:focus)::after{border-bottom-color:initial;}}",
        "@supports selector(:has(*)){.f1htdosj:has(.fui-Dropdown__clearButton:focus)::after{transform:scaleX(0);}}"
    ],
    f: [
        ".ftqa4ok:focus{outline-style:none;}"
    ],
    h: [
        ".fvcxoqz:hover{border-top-color:var(--colorNeutralStroke1Hover);}",
        ".f1ub3y4t:hover{border-right-color:var(--colorNeutralStroke1Hover);}",
        ".f1m52nbi:hover{border-left-color:var(--colorNeutralStroke1Hover);}",
        ".f1l4zc64:hover{border-bottom-color:var(--colorNeutralStrokeAccessibleHover);}"
    ],
    a: [
        ".fvs00aa:active{border-top-color:var(--colorNeutralStroke1Pressed);}",
        ".f1assf6x:active{border-right-color:var(--colorNeutralStroke1Pressed);}",
        ".f4ruux4:active{border-left-color:var(--colorNeutralStroke1Pressed);}",
        ".f1z0osm6:active{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"
    ]
});
const useIconStyles = /*#__PURE__*/ (0, _react.__styles)({
    icon: {
        B7ck84d: "f1ewtqcl",
        sj55zd: "fxkbij4",
        mc9l5x: "ftgm304",
        Be2twd7: "f1pp30po",
        Br312pm: "f12w6cgp",
        Bw0ie65: "f8bv1bt",
        Bo70h7d: "fvc9v3g"
    },
    small: {
        Be2twd7: "f4ybsrx",
        Frg6f3: [
            "f1h9en5y",
            "f1xk557c"
        ]
    },
    medium: {
        Be2twd7: "fe5j1ua",
        Frg6f3: [
            "f1h9en5y",
            "f1xk557c"
        ]
    },
    large: {
        Be2twd7: "f1rt2boy",
        Frg6f3: [
            "f1t5qyk5",
            "f1ikr372"
        ]
    },
    disabled: {
        sj55zd: "f1s2aq7o"
    }
}, {
    d: [
        ".f1ewtqcl{box-sizing:border-box;}",
        ".fxkbij4{color:var(--colorNeutralStrokeAccessible);}",
        ".ftgm304{display:block;}",
        ".f1pp30po{font-size:var(--fontSizeBase500);}",
        ".f12w6cgp{grid-column-start:icon;}",
        ".f8bv1bt{grid-column-end:end;}",
        ".fvc9v3g svg{display:block;}",
        ".f4ybsrx{font-size:16px;}",
        ".f1h9en5y{margin-left:var(--spacingHorizontalXXS);}",
        ".f1xk557c{margin-right:var(--spacingHorizontalXXS);}",
        ".fe5j1ua{font-size:20px;}",
        ".f1rt2boy{font-size:24px;}",
        ".f1t5qyk5{margin-left:var(--spacingHorizontalSNudge);}",
        ".f1ikr372{margin-right:var(--spacingHorizontalSNudge);}",
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}"
    ]
});
const useBaseClearButtonStyle = /*#__PURE__*/ (0, _react.__resetStyles)("rticfuj", "r1vp6jef", {
    r: [
        ".rticfuj{align-self:center;background-color:var(--colorTransparentBackground);border:none;cursor:pointer;height:fit-content;margin:0;margin-right:var(--spacingHorizontalMNudge);padding:0;position:relative;}",
        ".rticfuj:focus{outline-style:none;}",
        ".rticfuj:focus-visible{outline-style:none;}",
        ".rticfuj[data-fui-focus-visible]{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}",
        ".rticfuj[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}",
        ".r1vp6jef{align-self:center;background-color:var(--colorTransparentBackground);border:none;cursor:pointer;height:fit-content;margin:0;margin-left:var(--spacingHorizontalMNudge);padding:0;position:relative;}",
        ".r1vp6jef:focus{outline-style:none;}",
        ".r1vp6jef:focus-visible{outline-style:none;}",
        ".r1vp6jef[data-fui-focus-visible]{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}",
        ".r1vp6jef[data-fui-focus-visible]::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}"
    ],
    s: [
        "@media (forced-colors: active){.rticfuj[data-fui-focus-visible]::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}",
        "@media (forced-colors: active){.r1vp6jef[data-fui-focus-visible]::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}"
    ]
});
const useDropdownStyles_unstable = (state)=>{
    'use no memo';
    const { appearance, open, placeholderVisible, showClearButton, size } = state;
    const invalid = `${state.button['aria-invalid']}` === 'true';
    const disabled = state.button.disabled;
    const styles = useStyles();
    const iconStyles = useIconStyles();
    const clearButtonStyle = useBaseClearButtonStyle();
    state.root.className = (0, _react.mergeClasses)(dropdownClassNames.root, styles.root, styles[appearance], !disabled && appearance === 'outline' && styles.outlineInteractive, invalid && appearance !== 'underline' && styles.invalid, invalid && appearance === 'underline' && styles.invalidUnderline, disabled && styles.disabled, state.root.className);
    state.button.className = (0, _react.mergeClasses)(dropdownClassNames.button, styles.button, styles[size], placeholderVisible && styles.placeholder, disabled && styles.disabledText, state.button.className);
    if (state.listbox) {
        state.listbox.className = (0, _react.mergeClasses)(dropdownClassNames.listbox, styles.listbox, state.inlinePopup && styles.inlineListbox, !open && styles.listboxCollapsed, state.listbox.className);
    }
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(dropdownClassNames.expandIcon, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, showClearButton && styles.hidden, state.expandIcon.className);
    }
    if (state.clearButton) {
        state.clearButton.className = (0, _react.mergeClasses)(dropdownClassNames.clearButton, clearButtonStyle, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, !showClearButton && styles.hidden, state.clearButton.className);
    }
    return state;
};
