'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useDropdown_unstable", {
    enumerable: true,
    get: function() {
        return useDropdown_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reactaria = require("@fluentui/react-aria");
const _reacticons = require("@fluentui/react-icons");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reactutilities = require("@fluentui/react-utilities");
const _useComboboxBaseState = require("../../utils/useComboboxBaseState");
const _useComboboxPositioning = require("../../utils/useComboboxPositioning");
const _Listbox = require("../Listbox/Listbox");
const _useListboxSlot = require("../../utils/useListboxSlot");
const _useButtonTriggerSlot = require("./useButtonTriggerSlot");
const _useOptionStylesstyles = require("../Option/useOptionStyles.styles");
const useDropdown_unstable = (props, ref)=>{
    'use no memo';
    var _state_clearButton;
    // Merge props from surrounding <Field>, if any
    props = (0, _reactfield.useFieldControlProps_unstable)(props, {
        supportsLabelFor: true,
        supportsSize: true
    });
    const { listboxRef: activeDescendantListboxRef, activeParentRef, controller: activeDescendantController } = (0, _reactaria.useActiveDescendant)({
        matchOption: (el)=>el.classList.contains(_useOptionStylesstyles.optionClassNames.root)
    });
    const baseState = (0, _useComboboxBaseState.useComboboxBaseState)({
        ...props,
        activeDescendantController,
        freeform: false
    });
    const { clearable, clearSelection, disabled, hasFocus, multiselect, open, selectedOptions, setOpen } = baseState;
    const { primary: triggerNativeProps, root: rootNativeProps } = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'button',
        excludedPropNames: [
            'children'
        ]
    });
    const [comboboxPopupRef, comboboxTargetRef] = (0, _useComboboxPositioning.useComboboxPositioning)(props);
    const triggerRef = _react.useRef(null);
    const listbox = (0, _useListboxSlot.useListboxSlot)(props.listbox, (0, _reactutilities.useMergedRefs)(comboboxPopupRef, activeDescendantListboxRef), {
        state: baseState,
        triggerRef,
        defaultProps: {
            children: props.children
        }
    });
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    (0, _reactutilities.useOnClickOutside)({
        element: targetDocument,
        callback: (event)=>setOpen(event, false),
        refs: [
            triggerRef,
            comboboxPopupRef,
            comboboxTargetRef
        ],
        disabled: !open
    });
    var _props_button;
    const trigger = (0, _useButtonTriggerSlot.useButtonTriggerSlot)((_props_button = props.button) !== null && _props_button !== void 0 ? _props_button : {}, (0, _reactutilities.useMergedRefs)(triggerRef, activeParentRef, ref), {
        state: baseState,
        defaultProps: {
            type: 'button',
            // tabster navigation breaks if the button is disabled and tabIndex is 0
            tabIndex: triggerNativeProps.disabled ? undefined : 0,
            children: baseState.value || props.placeholder,
            'aria-controls': open ? listbox === null || listbox === void 0 ? void 0 : listbox.id : undefined,
            ...triggerNativeProps
        },
        activeDescendantController
    });
    const rootSlot = _reactutilities.slot.always(props.root, {
        defaultProps: {
            'aria-owns': !props.inlinePopup && open ? listbox === null || listbox === void 0 ? void 0 : listbox.id : undefined,
            children: props.children,
            ...rootNativeProps
        },
        elementType: 'div'
    });
    rootSlot.ref = (0, _reactutilities.useMergedRefs)(rootSlot.ref, comboboxTargetRef);
    const showClearButton = selectedOptions.length > 0 && !disabled && clearable && !multiselect;
    const state = {
        components: {
            root: 'div',
            button: 'button',
            clearButton: 'button',
            expandIcon: 'span',
            listbox: _Listbox.Listbox
        },
        root: rootSlot,
        button: trigger,
        listbox: open || hasFocus ? listbox : undefined,
        clearButton: _reactutilities.slot.optional(props.clearButton, {
            defaultProps: {
                'aria-label': 'Clear selection',
                children: /*#__PURE__*/ _react.createElement(_reacticons.DismissRegular, null),
                // Safari doesn't allow to focus an element with this
                // when the element is not visible (display: none) we need to remove it to avoid tabster issues
                tabIndex: showClearButton ? 0 : undefined,
                type: 'button'
            },
            elementType: 'button',
            renderByDefault: true
        }),
        expandIcon: _reactutilities.slot.optional(props.expandIcon, {
            renderByDefault: true,
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(_reacticons.ChevronDownRegular, null)
            },
            elementType: 'span'
        }),
        placeholderVisible: !baseState.value && !!props.placeholder,
        showClearButton,
        activeDescendantController,
        ...baseState
    };
    const onClearButtonClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)((_state_clearButton = state.clearButton) === null || _state_clearButton === void 0 ? void 0 : _state_clearButton.onClick, (ev)=>{
        var _triggerRef_current;
        clearSelection(ev);
        (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
    }));
    if (state.clearButton) {
        state.clearButton.onClick = onClearButtonClick;
    }
    // Heads up! We don't support "clearable" in multiselect mode, so we should never display a slot
    if (multiselect) {
        state.clearButton = undefined;
    }
    if (process.env.NODE_ENV !== 'production') {
        // eslint-disable-next-line react-hooks/rules-of-hooks -- "process.env" does not change in runtime
        _react.useEffect(()=>{
            if (clearable && multiselect) {
                // eslint-disable-next-line no-console
                console.error(`[@fluentui/react-combobox] "clearable" prop is not supported in multiselect mode.`);
            }
        }, [
            clearable,
            multiselect
        ]);
    }
    return state;
};
