'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useInputTriggerSlot", {
    enumerable: true,
    get: function() {
        return useInputTriggerSlot;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const _useTriggerSlot = require("../../utils/useTriggerSlot");
const _dropdownKeyActions = require("../../utils/dropdownKeyActions");
function useInputTriggerSlot(triggerFromProps, ref, options) {
    'use no memo';
    const { state: { open, value, selectOption, setValue, multiselect, selectedOptions, clearSelection, getOptionById, setOpen }, freeform, defaultProps, activeDescendantController } = options;
    const onBlur = (event)=>{
        // handle selection and updating value if freeform is false
        if (!open && !freeform) {
            const activeOptionId = activeDescendantController.active();
            const activeOption = activeOptionId ? getOptionById(activeOptionId) : null;
            // select matching option, if the value fully matches
            if (value && activeOption && value.trim().toLowerCase() === (activeOption === null || activeOption === void 0 ? void 0 : activeOption.text.toLowerCase())) {
                selectOption(event, activeOption);
            }
            // reset typed value when the input loses focus while collapsed, unless freeform is true
            setValue(undefined);
        }
    };
    const getOptionFromInput = (inputValue)=>{
        const searchString = inputValue === null || inputValue === void 0 ? void 0 : inputValue.trim().toLowerCase();
        if (!searchString || searchString.length === 0) {
            activeDescendantController.blur();
            return;
        }
        const matcher = (optionText)=>optionText.toLowerCase().indexOf(searchString) === 0;
        const match = activeDescendantController.find((id)=>{
            const option = getOptionById(id);
            return !!option && matcher(option.text);
        });
        if (!match) {
            activeDescendantController.blur();
            return undefined;
        }
        return getOptionById(match);
    };
    // update value and active option based on input
    const onChange = (event)=>{
        const inputValue = event.target.value;
        // update uncontrolled value
        setValue(inputValue);
        // handle updating active option based on input
        const matchingOption = getOptionFromInput(inputValue);
        // clear selection for single-select if the input value no longer matches the selection
        if (!multiselect && selectedOptions.length === 1 && (inputValue.length < 1 || !matchingOption)) {
            clearSelection(event);
        }
    };
    const trigger = (0, _useTriggerSlot.useTriggerSlot)(triggerFromProps, ref, {
        state: options.state,
        defaultProps,
        elementType: 'input',
        activeDescendantController
    });
    trigger.onChange = (0, _reactutilities.mergeCallbacks)(trigger.onChange, onChange);
    trigger.onBlur = (0, _reactutilities.mergeCallbacks)(trigger.onBlur, onBlur);
    // NVDA and JAWS have bugs that suppress reading the input value text when aria-activedescendant is set
    // To prevent this, we clear the HTML attribute (but save the state) when a user presses left/right arrows
    // ref: https://github.com/microsoft/fluentui/issues/26359#issuecomment-1397759888
    const [hideActiveDescendant, setHideActiveDescendant] = _react.useState(false);
    // save the typing vs. navigating options state, as the space key should behave differently in each case
    // we do not want to update the combobox when this changes, just save the value between renders
    const isTyping = _react.useRef(false);
    /**
   * Freeform combobox should not select
   */ const defaultOnKeyDown = trigger.onKeyDown;
    const onKeyDown = (0, _reactutilities.useEventCallback)((event)=>{
        if (!open && (0, _dropdownKeyActions.getDropdownActionFromKey)(event) === 'Type') {
            setOpen(event, true);
        }
        // clear activedescendant when moving the text insertion cursor
        if (event.key === _keyboardkeys.ArrowLeft || event.key === _keyboardkeys.ArrowRight) {
            setHideActiveDescendant(true);
        } else {
            setHideActiveDescendant(false);
        }
        // update typing state to true if the user is typing
        const action = (0, _dropdownKeyActions.getDropdownActionFromKey)(event, {
            open,
            multiselect
        });
        if (action === 'Type') {
            isTyping.current = true;
        } else if (action === 'Open' && event.key !== ' ' || action === 'Next' || action === 'Previous' || action === 'First' || action === 'Last' || action === 'PageUp' || action === 'PageDown') {
            isTyping.current = false;
        }
        // allow space to insert a character if freeform & the last action was typing, or if the popup is closed
        if ((isTyping.current || !open) && event.key === ' ') {
            var _triggerFromProps_onKeyDown;
            triggerFromProps === null || triggerFromProps === void 0 ? void 0 : (_triggerFromProps_onKeyDown = triggerFromProps.onKeyDown) === null || _triggerFromProps_onKeyDown === void 0 ? void 0 : _triggerFromProps_onKeyDown.call(triggerFromProps, event);
            return;
        }
        defaultOnKeyDown === null || defaultOnKeyDown === void 0 ? void 0 : defaultOnKeyDown(event);
    });
    trigger.onKeyDown = onKeyDown;
    if (hideActiveDescendant) {
        trigger['aria-activedescendant'] = undefined;
    }
    return trigger;
}
