'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    comboboxClassNames: function() {
        return comboboxClassNames;
    },
    useComboboxStyles_unstable: function() {
        return useComboboxStyles_unstable;
    }
});
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const _internalTokens = require("../../utils/internalTokens");
const comboboxClassNames = {
    root: 'fui-Combobox',
    input: 'fui-Combobox__input',
    expandIcon: 'fui-Combobox__expandIcon',
    clearIcon: 'fui-Combobox__clearIcon',
    listbox: 'fui-Combobox__listbox'
};
// Matches internal heights for Select and Input, but there are no theme variables for these
const fieldHeights = {
    small: '24px',
    medium: '32px',
    large: '40px'
};
/**
 * Styles for Combobox
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        alignItems: 'center',
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        boxSizing: 'border-box',
        columnGap: _reacttheme.tokens.spacingHorizontalXXS,
        display: 'inline-grid',
        gridTemplateColumns: '1fr auto',
        justifyContent: 'space-between',
        minWidth: '250px',
        position: 'relative',
        verticalAlign: 'middle',
        // windows high contrast mode focus indicator
        ':focus-within': {
            outlineWidth: '2px',
            outlineStyle: 'solid',
            outlineColor: 'transparent'
        },
        // bottom focus border, shared with Input, Select, and SpinButton
        '::after': {
            boxSizing: 'border-box',
            content: '""',
            position: 'absolute',
            left: '-1px',
            bottom: '-1px',
            right: '-1px',
            height: `max(2px, ${_reacttheme.tokens.borderRadiusMedium})`,
            borderBottomLeftRadius: _reacttheme.tokens.borderRadiusMedium,
            borderBottomRightRadius: _reacttheme.tokens.borderRadiusMedium,
            borderBottom: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorCompoundBrandStroke}`,
            clipPath: 'inset(calc(100% - 2px) 0 0 0)',
            transform: 'scaleX(0)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationUltraFast,
            transitionDelay: _reacttheme.tokens.curveAccelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within::after': {
            transform: 'scaleX(1)',
            transitionProperty: 'transform',
            transitionDuration: _reacttheme.tokens.durationNormal,
            transitionDelay: _reacttheme.tokens.curveDecelerateMid,
            '@media screen and (prefers-reduced-motion: reduce)': {
                transitionDuration: '0.01ms',
                transitionDelay: '0.01ms'
            }
        },
        ':focus-within:active::after': {
            borderBottomColor: _reacttheme.tokens.colorCompoundBrandStrokePressed
        }
    },
    listbox: {
        boxShadow: `${_reacttheme.tokens.shadow16}`,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        maxHeight: '80vh',
        boxSizing: 'border-box'
    },
    listboxCollapsed: {
        display: 'none'
    },
    // When rendering inline, the popupSurface will be rendered under relatively positioned elements such as Input.
    // This is due to the surface being positioned as absolute, therefore zIndex: 1 ensures that won't happen.
    inlineListbox: {
        zIndex: 1
    },
    // size variants
    small: {
        height: fieldHeights.small,
        paddingRight: _reacttheme.tokens.spacingHorizontalSNudge
    },
    medium: {
        height: fieldHeights.medium,
        paddingRight: _reacttheme.tokens.spacingHorizontalMNudge
    },
    large: {
        columnGap: _reacttheme.tokens.spacingHorizontalSNudge,
        height: fieldHeights.large,
        paddingRight: _reacttheme.tokens.spacingHorizontalM
    },
    // appearance variants
    outline: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStroke1}`,
        borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessible
    },
    outlineInteractive: {
        '&:hover': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
        },
        '&:active': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        },
        '&:focus-within': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed),
            borderBottomColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        }
    },
    underline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        borderBottom: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralStrokeAccessible}`,
        borderRadius: '0'
    },
    'filled-lighter': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`
    },
    'filled-darker': {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground3,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorTransparentStroke}`
    },
    invalid: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            ..._react.shorthands.borderColor(_reacttheme.tokens.colorPaletteRedBorder2)
        }
    },
    invalidUnderline: {
        ':not(:focus-within),:hover:not(:focus-within)': {
            borderBottomColor: _reacttheme.tokens.colorPaletteRedBorder2
        }
    },
    disabled: {
        cursor: 'not-allowed',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        '@media (forced-colors: active)': {
            ..._react.shorthands.borderColor('GrayText')
        }
    }
});
const useInputStyles = (0, _react.makeStyles)({
    input: {
        alignSelf: 'stretch',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        border: 'none',
        color: _reacttheme.tokens.colorNeutralForeground1,
        fontFamily: _reacttheme.tokens.fontFamilyBase,
        '&:focus': {
            outlineStyle: 'none'
        },
        '&::placeholder': {
            color: _reacttheme.tokens.colorNeutralForeground4,
            opacity: 1
        }
    },
    // size variants
    small: {
        ..._reacttheme.typographyStyles.caption1,
        padding: `0 0 0 ${`calc(${_reacttheme.tokens.spacingHorizontalSNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`}`
    },
    medium: {
        ..._reacttheme.typographyStyles.body1,
        padding: `0 0 0 ${`calc(${_reacttheme.tokens.spacingHorizontalMNudge} + ${_reacttheme.tokens.spacingHorizontalXXS})`}`
    },
    large: {
        ..._reacttheme.typographyStyles.body2,
        padding: `0 0 0 ${`calc(${_reacttheme.tokens.spacingHorizontalM} + ${_reacttheme.tokens.spacingHorizontalSNudge})`}`
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        cursor: 'not-allowed',
        '::placeholder': {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled
        }
    }
});
const useIconStyles = (0, _react.makeStyles)({
    icon: {
        boxSizing: 'border-box',
        color: _reacttheme.tokens.colorNeutralStrokeAccessible,
        cursor: 'pointer',
        display: 'block',
        fontSize: _reacttheme.tokens.fontSizeBase500,
        // the SVG must have display: block for accurate positioning
        // otherwise an extra inline space is inserted after the svg element
        '& svg': {
            display: 'block'
        }
    },
    hidden: {
        display: 'none'
    },
    visuallyHidden: {
        clip: 'rect(0px, 0px, 0px, 0px)',
        height: '1px',
        margin: '-1px',
        overflow: 'hidden',
        padding: '0px',
        width: '1px',
        position: 'absolute'
    },
    // icon size variants
    small: {
        fontSize: _internalTokens.iconSizes.small,
        marginLeft: _reacttheme.tokens.spacingHorizontalXXS
    },
    medium: {
        fontSize: _internalTokens.iconSizes.medium,
        marginLeft: _reacttheme.tokens.spacingHorizontalXXS
    },
    large: {
        fontSize: _internalTokens.iconSizes.large,
        marginLeft: _reacttheme.tokens.spacingHorizontalSNudge
    },
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        cursor: 'not-allowed'
    }
});
const useComboboxStyles_unstable = (state)=>{
    'use no memo';
    const { appearance, open, size, showClearIcon } = state;
    const invalid = `${state.input['aria-invalid']}` === 'true';
    const disabled = state.input.disabled;
    const styles = useStyles();
    const iconStyles = useIconStyles();
    const inputStyles = useInputStyles();
    state.root.className = (0, _react.mergeClasses)(comboboxClassNames.root, styles.root, styles[appearance], styles[size], !disabled && appearance === 'outline' && styles.outlineInteractive, invalid && appearance !== 'underline' && styles.invalid, invalid && appearance === 'underline' && styles.invalidUnderline, disabled && styles.disabled, state.root.className);
    state.input.className = (0, _react.mergeClasses)(comboboxClassNames.input, inputStyles.input, inputStyles[size], disabled && inputStyles.disabled, state.input.className);
    if (state.listbox) {
        state.listbox.className = (0, _react.mergeClasses)(comboboxClassNames.listbox, styles.listbox, state.inlinePopup && styles.inlineListbox, !open && styles.listboxCollapsed, state.listbox.className);
    }
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(comboboxClassNames.expandIcon, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, showClearIcon && iconStyles.visuallyHidden, state.expandIcon.className);
    }
    if (state.clearIcon) {
        state.clearIcon.className = (0, _react.mergeClasses)(comboboxClassNames.clearIcon, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, !showClearIcon && iconStyles.hidden, state.clearIcon.className);
    }
    return state;
};
