'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    comboboxClassNames: function() {
        return comboboxClassNames;
    },
    useComboboxStyles_unstable: function() {
        return useComboboxStyles_unstable;
    }
});
const _react = require("@griffel/react");
const comboboxClassNames = {
    root: 'fui-Combobox',
    input: 'fui-Combobox__input',
    expandIcon: 'fui-Combobox__expandIcon',
    clearIcon: 'fui-Combobox__clearIcon',
    listbox: 'fui-Combobox__listbox'
};
// Matches internal heights for Select and Input, but there are no theme variables for these
const fieldHeights = {
    small: '24px',
    medium: '32px',
    large: '40px'
};
/**
 * Styles for Combobox
 */ const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        Bt984gj: "f122n59",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "ft85np5",
        B7ck84d: "f1ewtqcl",
        i8kkvl: "f14mj54c",
        mc9l5x: "fwk3njj",
        Budl1dq: "fz17x9o",
        Brf1p80: "f1869bpl",
        Bf4jedk: "f1exfvgq",
        qhf8xq: "f10pi13n",
        ha4doy: "fmrv4ls",
        Bbr2w1p: "f14a1fxs",
        Bduesf4: "f3e99gv",
        Bpq79vn: "fhljsf7",
        li1rpt: "f1gw3sf2",
        Bsft5z2: "f13zj6fq",
        E3zdtr: "f1mdlcz9",
        Eqx8gd: [
            "f1a7op3",
            "f1cjjd47"
        ],
        By385i5: "f1gboi2j",
        B1piin3: [
            "f1cjjd47",
            "f1a7op3"
        ],
        Dlnsje: "f145g4dw",
        d9w3h3: [
            "f1kp91vd",
            "f1ibwz09"
        ],
        B3778ie: [
            "f1ibwz09",
            "f1kp91vd"
        ],
        B1q35kw: 0,
        Bw17bha: 0,
        Bcgy8vk: 0,
        Bjuhk93: "f1mnjydx",
        Gjdm7m: "f13evtba",
        b1kco5: "f1yk9hq",
        Ba2ppi3: "fhwpy7i",
        F2fol1: "f14ee0xe",
        lck23g: "f1xhbsuh",
        df92cz: "fv8e3ye",
        I188md: "ftb5wc6",
        umuwi5: "fjw5xc1",
        Blcqepd: "f1xdyd5c",
        nplu4u: "fatpbeo",
        Bioka5o: "fb7uyps",
        H713fs: "f1cmft4k",
        B9ooomg: "f1x58t8o",
        Bercvud: "f1ibeo51"
    },
    listbox: {
        E5pizo: "f1hg901r",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "ft85np5",
        Bxyxcbc: "fmmk62d",
        B7ck84d: "f1ewtqcl"
    },
    listboxCollapsed: {
        mc9l5x: "fjseox"
    },
    inlineListbox: {
        Bj3rh1h: "f19g0ac"
    },
    small: {
        Bqenvij: "frvgh55",
        z189sj: [
            "fdw0yi8",
            "fk8j09s"
        ]
    },
    medium: {
        Bqenvij: "f1d2rq10",
        z189sj: [
            "f11gcy0p",
            "f1ng84yb"
        ]
    },
    large: {
        i8kkvl: "f1rjii52",
        Bqenvij: "fbhnoac",
        z189sj: [
            "fw5db7e",
            "f1uw59to"
        ]
    },
    outline: {
        De3pzq: "fxugw4r",
        Bgfg5da: 0,
        B9xav0g: "f1c1zstj",
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "fhz96rm"
    },
    outlineInteractive: {
        Bgoe8wy: "fvcxoqz",
        Bwzppfd: [
            "f1ub3y4t",
            "f1m52nbi"
        ],
        oetu4i: "f1l4zc64",
        gg5e9n: [
            "f1m52nbi",
            "f1ub3y4t"
        ],
        B6oc9vd: "fvs00aa",
        ak43y8: [
            "f1assf6x",
            "f4ruux4"
        ],
        wmxk5l: "f1z0osm6",
        B50zh58: [
            "f4ruux4",
            "f1assf6x"
        ],
        Bvq3b66: "f1b473iu",
        Brahy3i: [
            "f381qr8",
            "ft4skwv"
        ],
        zoxjo1: "f1qzcrsd",
        an54nd: [
            "ft4skwv",
            "f381qr8"
        ]
    },
    underline: {
        De3pzq: "f1c21dwh",
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        Bgfg5da: "f9ez7ne",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "fokr779"
    },
    "filled-lighter": {
        De3pzq: "fxugw4r",
        Bgfg5da: 0,
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "f88035w"
    },
    "filled-darker": {
        De3pzq: "f16xq7d1",
        Bgfg5da: 0,
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "f88035w"
    },
    invalid: {
        tvckwq: "fs4k3qj",
        gk2u95: [
            "fcee079",
            "fmyw78r"
        ],
        hhx65j: "f1fgmyf4",
        Bxowmz0: [
            "fmyw78r",
            "fcee079"
        ]
    },
    invalidUnderline: {
        hhx65j: "f1fgmyf4"
    },
    disabled: {
        Bceei9c: "fdrzuqr",
        De3pzq: "f1c21dwh",
        g2u3we: "f1jj8ep1",
        h3c5rm: [
            "f15xbau",
            "fy0fskl"
        ],
        B9xav0g: "f4ikngz",
        zhjwy3: [
            "fy0fskl",
            "f15xbau"
        ],
        Bjwas2f: "fg455y9",
        Bn1d65q: [
            "f1rvyvqg",
            "f14g86mu"
        ],
        Bxeuatn: "f1cwzwz",
        n51gp8: [
            "f14g86mu",
            "f1rvyvqg"
        ]
    }
}, {
    d: [
        ".f122n59{align-items:center;}",
        [
            ".ft85np5{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".f1ewtqcl{box-sizing:border-box;}",
        ".f14mj54c{column-gap:var(--spacingHorizontalXXS);}",
        ".fwk3njj{display:inline-grid;}",
        ".fz17x9o{grid-template-columns:1fr auto;}",
        ".f1869bpl{justify-content:space-between;}",
        ".f1exfvgq{min-width:250px;}",
        ".f10pi13n{position:relative;}",
        ".fmrv4ls{vertical-align:middle;}",
        ".f1gw3sf2::after{box-sizing:border-box;}",
        ".f13zj6fq::after{content:\"\";}",
        ".f1mdlcz9::after{position:absolute;}",
        ".f1a7op3::after{left:-1px;}",
        ".f1cjjd47::after{right:-1px;}",
        ".f1gboi2j::after{bottom:-1px;}",
        ".f145g4dw::after{height:max(2px, var(--borderRadiusMedium));}",
        ".f1kp91vd::after{border-bottom-left-radius:var(--borderRadiusMedium);}",
        ".f1ibwz09::after{border-bottom-right-radius:var(--borderRadiusMedium);}",
        [
            ".f1mnjydx::after{border-bottom:var(--strokeWidthThick) solid var(--colorCompoundBrandStroke);}",
            {
                p: -1
            }
        ],
        ".f13evtba::after{clip-path:inset(calc(100% - 2px) 0 0 0);}",
        ".f1yk9hq::after{transform:scaleX(0);}",
        ".fhwpy7i::after{transition-property:transform;}",
        ".f14ee0xe::after{transition-duration:var(--durationUltraFast);}",
        ".f1xhbsuh::after{transition-delay:var(--curveAccelerateMid);}",
        ".f1hg901r{box-shadow:var(--shadow16);}",
        [
            ".ft85np5{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".fmmk62d{max-height:80vh;}",
        ".fjseox{display:none;}",
        ".f19g0ac{z-index:1;}",
        ".frvgh55{height:24px;}",
        ".fdw0yi8{padding-right:var(--spacingHorizontalSNudge);}",
        ".fk8j09s{padding-left:var(--spacingHorizontalSNudge);}",
        ".f1d2rq10{height:32px;}",
        ".f11gcy0p{padding-right:var(--spacingHorizontalMNudge);}",
        ".f1ng84yb{padding-left:var(--spacingHorizontalMNudge);}",
        ".f1rjii52{column-gap:var(--spacingHorizontalSNudge);}",
        ".fbhnoac{height:40px;}",
        ".fw5db7e{padding-right:var(--spacingHorizontalM);}",
        ".f1uw59to{padding-left:var(--spacingHorizontalM);}",
        ".fxugw4r{background-color:var(--colorNeutralBackground1);}",
        [
            ".fhz96rm{border:var(--strokeWidthThin) solid var(--colorNeutralStroke1);}",
            {
                p: -2
            }
        ],
        ".f1c1zstj{border-bottom-color:var(--colorNeutralStrokeAccessible);}",
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}",
        [
            ".f9ez7ne{border-bottom:var(--strokeWidthThin) solid var(--colorNeutralStrokeAccessible);}",
            {
                p: -1
            }
        ],
        [
            ".fokr779{border-radius:0;}",
            {
                p: -1
            }
        ],
        [
            ".f88035w{border:var(--strokeWidthThin) solid var(--colorTransparentStroke);}",
            {
                p: -2
            }
        ],
        ".f16xq7d1{background-color:var(--colorNeutralBackground3);}",
        [
            ".f88035w{border:var(--strokeWidthThin) solid var(--colorTransparentStroke);}",
            {
                p: -2
            }
        ],
        ".fs4k3qj:not(:focus-within),.fs4k3qj:hover:not(:focus-within){border-top-color:var(--colorPaletteRedBorder2);}",
        ".fcee079:not(:focus-within),.fcee079:hover:not(:focus-within){border-right-color:var(--colorPaletteRedBorder2);}",
        ".fmyw78r:not(:focus-within),.fmyw78r:hover:not(:focus-within){border-left-color:var(--colorPaletteRedBorder2);}",
        ".f1fgmyf4:not(:focus-within),.f1fgmyf4:hover:not(:focus-within){border-bottom-color:var(--colorPaletteRedBorder2);}",
        ".fdrzuqr{cursor:not-allowed;}",
        ".f1jj8ep1{border-top-color:var(--colorNeutralStrokeDisabled);}",
        ".f15xbau{border-right-color:var(--colorNeutralStrokeDisabled);}",
        ".fy0fskl{border-left-color:var(--colorNeutralStrokeDisabled);}",
        ".f4ikngz{border-bottom-color:var(--colorNeutralStrokeDisabled);}"
    ],
    w: [
        ".f14a1fxs:focus-within{outline-width:2px;}",
        ".f3e99gv:focus-within{outline-style:solid;}",
        ".fhljsf7:focus-within{outline-color:transparent;}",
        ".fjw5xc1:focus-within::after{transform:scaleX(1);}",
        ".f1xdyd5c:focus-within::after{transition-property:transform;}",
        ".fatpbeo:focus-within::after{transition-duration:var(--durationNormal);}",
        ".fb7uyps:focus-within::after{transition-delay:var(--curveDecelerateMid);}",
        ".f1ibeo51:focus-within:active::after{border-bottom-color:var(--colorCompoundBrandStrokePressed);}",
        ".f1b473iu:focus-within{border-top-color:var(--colorNeutralStroke1Pressed);}",
        ".f381qr8:focus-within{border-right-color:var(--colorNeutralStroke1Pressed);}",
        ".ft4skwv:focus-within{border-left-color:var(--colorNeutralStroke1Pressed);}",
        ".f1qzcrsd:focus-within{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"
    ],
    m: [
        [
            "@media screen and (prefers-reduced-motion: reduce){.fv8e3ye::after{transition-duration:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (prefers-reduced-motion: reduce){.ftb5wc6::after{transition-delay:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (prefers-reduced-motion: reduce){.f1cmft4k:focus-within::after{transition-duration:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media screen and (prefers-reduced-motion: reduce){.f1x58t8o:focus-within::after{transition-delay:0.01ms;}}",
            {
                m: "screen and (prefers-reduced-motion: reduce)"
            }
        ],
        [
            "@media (forced-colors: active){.fg455y9{border-top-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f14g86mu{border-left-color:GrayText;}.f1rvyvqg{border-right-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1cwzwz{border-bottom-color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ],
    h: [
        ".fvcxoqz:hover{border-top-color:var(--colorNeutralStroke1Hover);}",
        ".f1ub3y4t:hover{border-right-color:var(--colorNeutralStroke1Hover);}",
        ".f1m52nbi:hover{border-left-color:var(--colorNeutralStroke1Hover);}",
        ".f1l4zc64:hover{border-bottom-color:var(--colorNeutralStrokeAccessibleHover);}"
    ],
    a: [
        ".fvs00aa:active{border-top-color:var(--colorNeutralStroke1Pressed);}",
        ".f1assf6x:active{border-right-color:var(--colorNeutralStroke1Pressed);}",
        ".f4ruux4:active{border-left-color:var(--colorNeutralStroke1Pressed);}",
        ".f1z0osm6:active{border-bottom-color:var(--colorNeutralStrokeAccessiblePressed);}"
    ]
});
const useInputStyles = /*#__PURE__*/ (0, _react.__styles)({
    input: {
        qb2dma: "f1ub7u0d",
        De3pzq: "f1c21dwh",
        Bgfg5da: 0,
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "f3bhgqh",
        sj55zd: "f19n0e5",
        Bahqtrf: "fk6fouc",
        Brovlpu: "ftqa4ok",
        yvdlaj: "fwyc1cq",
        B3o7kgh: "f13ta7ih"
    },
    small: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fy9rknc",
        Bhrd7zp: "figsok6",
        Bg96gwp: "fwrc4pm",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "fxe2rs",
            "f1gflqzi"
        ]
    },
    medium: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fkhj508",
        Bhrd7zp: "figsok6",
        Bg96gwp: "f1i3iumi",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "fzy81xo",
            "f58b53b"
        ]
    },
    large: {
        Bahqtrf: "fk6fouc",
        Be2twd7: "fod5ikn",
        Bhrd7zp: "figsok6",
        Bg96gwp: "faaz57k",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: [
            "f1kdav7a",
            "footqm6"
        ]
    },
    disabled: {
        sj55zd: "f1s2aq7o",
        De3pzq: "f1c21dwh",
        Bceei9c: "fdrzuqr",
        yvdlaj: "fahhnxm"
    }
}, {
    d: [
        ".f1ub7u0d{align-self:stretch;}",
        ".f1c21dwh{background-color:var(--colorTransparentBackground);}",
        [
            ".f3bhgqh{border:none;}",
            {
                p: -2
            }
        ],
        ".f19n0e5{color:var(--colorNeutralForeground1);}",
        ".fk6fouc{font-family:var(--fontFamilyBase);}",
        ".fwyc1cq::-webkit-input-placeholder{color:var(--colorNeutralForeground4);}",
        ".fwyc1cq::-moz-placeholder{color:var(--colorNeutralForeground4);}",
        ".f13ta7ih::-webkit-input-placeholder{opacity:1;}",
        ".f13ta7ih::-moz-placeholder{opacity:1;}",
        ".fy9rknc{font-size:var(--fontSizeBase200);}",
        ".figsok6{font-weight:var(--fontWeightRegular);}",
        ".fwrc4pm{line-height:var(--lineHeightBase200);}",
        [
            ".fxe2rs{padding:0 0 0 calc(var(--spacingHorizontalSNudge) + var(--spacingHorizontalXXS));}",
            {
                p: -1
            }
        ],
        [
            ".f1gflqzi{padding:0 calc(var(--spacingHorizontalSNudge) + var(--spacingHorizontalXXS)) 0 0;}",
            {
                p: -1
            }
        ],
        ".fkhj508{font-size:var(--fontSizeBase300);}",
        ".f1i3iumi{line-height:var(--lineHeightBase300);}",
        [
            ".fzy81xo{padding:0 0 0 calc(var(--spacingHorizontalMNudge) + var(--spacingHorizontalXXS));}",
            {
                p: -1
            }
        ],
        [
            ".f58b53b{padding:0 calc(var(--spacingHorizontalMNudge) + var(--spacingHorizontalXXS)) 0 0;}",
            {
                p: -1
            }
        ],
        ".fod5ikn{font-size:var(--fontSizeBase400);}",
        ".faaz57k{line-height:var(--lineHeightBase400);}",
        [
            ".f1kdav7a{padding:0 0 0 calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge));}",
            {
                p: -1
            }
        ],
        [
            ".footqm6{padding:0 calc(var(--spacingHorizontalM) + var(--spacingHorizontalSNudge)) 0 0;}",
            {
                p: -1
            }
        ],
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
        ".fdrzuqr{cursor:not-allowed;}",
        ".fahhnxm::-webkit-input-placeholder{color:var(--colorNeutralForegroundDisabled);}",
        ".fahhnxm::-moz-placeholder{color:var(--colorNeutralForegroundDisabled);}"
    ],
    f: [
        ".ftqa4ok:focus{outline-style:none;}"
    ]
});
const useIconStyles = /*#__PURE__*/ (0, _react.__styles)({
    icon: {
        B7ck84d: "f1ewtqcl",
        sj55zd: "fxkbij4",
        Bceei9c: "f1k6fduh",
        mc9l5x: "ftgm304",
        Be2twd7: "f1pp30po",
        Bo70h7d: "fvc9v3g"
    },
    hidden: {
        mc9l5x: "fjseox"
    },
    visuallyHidden: {
        Bh84pgu: "f1ekcaio",
        Bqenvij: "f1mpe4l3",
        jrapky: 0,
        Frg6f3: 0,
        t21cq0: 0,
        B6of3ja: 0,
        B74szlk: "f1jlpb2r",
        B68tc82: 0,
        Bmxbyg5: 0,
        Bpg54ce: "f1a3p1vp",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: "f1c5fvqg",
        a9b677: "frkrog8",
        qhf8xq: "f1euv43f"
    },
    small: {
        Be2twd7: "f4ybsrx",
        Frg6f3: [
            "f1h9en5y",
            "f1xk557c"
        ]
    },
    medium: {
        Be2twd7: "fe5j1ua",
        Frg6f3: [
            "f1h9en5y",
            "f1xk557c"
        ]
    },
    large: {
        Be2twd7: "f1rt2boy",
        Frg6f3: [
            "f1t5qyk5",
            "f1ikr372"
        ]
    },
    disabled: {
        sj55zd: "f1s2aq7o",
        Bceei9c: "fdrzuqr"
    }
}, {
    d: [
        ".f1ewtqcl{box-sizing:border-box;}",
        ".fxkbij4{color:var(--colorNeutralStrokeAccessible);}",
        ".f1k6fduh{cursor:pointer;}",
        ".ftgm304{display:block;}",
        ".f1pp30po{font-size:var(--fontSizeBase500);}",
        ".fvc9v3g svg{display:block;}",
        ".fjseox{display:none;}",
        ".f1ekcaio{clip:rect(0px, 0px, 0px, 0px);}",
        ".f1mpe4l3{height:1px;}",
        [
            ".f1jlpb2r{margin:-1px;}",
            {
                p: -1
            }
        ],
        [
            ".f1a3p1vp{overflow:hidden;}",
            {
                p: -1
            }
        ],
        [
            ".f1c5fvqg{padding:0px;}",
            {
                p: -1
            }
        ],
        ".frkrog8{width:1px;}",
        ".f1euv43f{position:absolute;}",
        ".f4ybsrx{font-size:16px;}",
        ".f1h9en5y{margin-left:var(--spacingHorizontalXXS);}",
        ".f1xk557c{margin-right:var(--spacingHorizontalXXS);}",
        ".fe5j1ua{font-size:20px;}",
        ".f1rt2boy{font-size:24px;}",
        ".f1t5qyk5{margin-left:var(--spacingHorizontalSNudge);}",
        ".f1ikr372{margin-right:var(--spacingHorizontalSNudge);}",
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
        ".fdrzuqr{cursor:not-allowed;}"
    ]
});
const useComboboxStyles_unstable = (state)=>{
    'use no memo';
    const { appearance, open, size, showClearIcon } = state;
    const invalid = `${state.input['aria-invalid']}` === 'true';
    const disabled = state.input.disabled;
    const styles = useStyles();
    const iconStyles = useIconStyles();
    const inputStyles = useInputStyles();
    state.root.className = (0, _react.mergeClasses)(comboboxClassNames.root, styles.root, styles[appearance], styles[size], !disabled && appearance === 'outline' && styles.outlineInteractive, invalid && appearance !== 'underline' && styles.invalid, invalid && appearance === 'underline' && styles.invalidUnderline, disabled && styles.disabled, state.root.className);
    state.input.className = (0, _react.mergeClasses)(comboboxClassNames.input, inputStyles.input, inputStyles[size], disabled && inputStyles.disabled, state.input.className);
    if (state.listbox) {
        state.listbox.className = (0, _react.mergeClasses)(comboboxClassNames.listbox, styles.listbox, state.inlinePopup && styles.inlineListbox, !open && styles.listboxCollapsed, state.listbox.className);
    }
    if (state.expandIcon) {
        state.expandIcon.className = (0, _react.mergeClasses)(comboboxClassNames.expandIcon, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, showClearIcon && iconStyles.visuallyHidden, state.expandIcon.className);
    }
    if (state.clearIcon) {
        state.clearIcon.className = (0, _react.mergeClasses)(comboboxClassNames.clearIcon, iconStyles.icon, iconStyles[size], disabled && iconStyles.disabled, !showClearIcon && iconStyles.hidden, state.clearIcon.className);
    }
    return state;
};
