'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCombobox_unstable", {
    enumerable: true,
    get: function() {
        return useCombobox_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactaria = require("@fluentui/react-aria");
const _reactfield = require("@fluentui/react-field");
const _reacticons = require("@fluentui/react-icons");
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useComboboxBaseState = require("../../utils/useComboboxBaseState");
const _useComboboxPositioning = require("../../utils/useComboboxPositioning");
const _Listbox = require("../Listbox/Listbox");
const _useListboxSlot = require("../../utils/useListboxSlot");
const _useInputTriggerSlot = require("./useInputTriggerSlot");
const _useOptionStylesstyles = require("../Option/useOptionStyles.styles");
const useCombobox_unstable = (props, ref)=>{
    'use no memo';
    var _state_clearIcon, _state_clearIcon1;
    // Merge props from surrounding <Field>, if any
    props = (0, _reactfield.useFieldControlProps_unstable)(props, {
        supportsLabelFor: true,
        supportsRequired: true,
        supportsSize: true
    });
    const { listboxRef: activeDescendantListboxRef, activeParentRef, controller: activeDescendantController } = (0, _reactaria.useActiveDescendant)({
        matchOption: (el)=>el.classList.contains(_useOptionStylesstyles.optionClassNames.root)
    });
    const baseState = (0, _useComboboxBaseState.useComboboxBaseState)({
        ...props,
        editable: true,
        activeDescendantController
    });
    const { clearable, clearSelection, disabled, multiselect, open, selectedOptions, setOpen, value, hasFocus } = baseState;
    const [comboboxPopupRef, comboboxTargetRef] = (0, _useComboboxPositioning.useComboboxPositioning)(props);
    const { disableAutoFocus = false, freeform, inlinePopup } = props;
    const comboId = (0, _reactutilities.useId)('combobox-');
    const { primary: triggerNativeProps, root: rootNativeProps } = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'input',
        excludedPropNames: [
            'children',
            'size'
        ]
    });
    const triggerRef = _react.useRef(null);
    const listbox = (0, _useListboxSlot.useListboxSlot)(props.listbox, (0, _reactutilities.useMergedRefs)(comboboxPopupRef, activeDescendantListboxRef), {
        state: baseState,
        triggerRef,
        defaultProps: {
            children: props.children,
            disableAutoFocus
        }
    });
    var _props_input;
    const triggerSlot = (0, _useInputTriggerSlot.useInputTriggerSlot)((_props_input = props.input) !== null && _props_input !== void 0 ? _props_input : {}, (0, _reactutilities.useMergedRefs)(triggerRef, activeParentRef, ref), {
        state: baseState,
        freeform,
        defaultProps: {
            type: 'text',
            value: value !== null && value !== void 0 ? value : '',
            'aria-controls': open ? listbox === null || listbox === void 0 ? void 0 : listbox.id : undefined,
            ...triggerNativeProps
        },
        activeDescendantController
    });
    const rootSlot = _reactutilities.slot.always(props.root, {
        defaultProps: {
            'aria-owns': !inlinePopup && open ? listbox === null || listbox === void 0 ? void 0 : listbox.id : undefined,
            ...rootNativeProps
        },
        elementType: 'div'
    });
    rootSlot.ref = (0, _reactutilities.useMergedRefs)(rootSlot.ref, comboboxTargetRef);
    const showClearIcon = selectedOptions.length > 0 && !disabled && clearable && !multiselect;
    const state = {
        components: {
            root: 'div',
            input: 'input',
            expandIcon: 'span',
            listbox: _Listbox.Listbox,
            clearIcon: 'span'
        },
        root: rootSlot,
        input: triggerSlot,
        listbox: open || hasFocus ? listbox : undefined,
        clearIcon: _reactutilities.slot.optional(props.clearIcon, {
            defaultProps: {
                'aria-hidden': 'true',
                children: /*#__PURE__*/ _react.createElement(_reacticons.DismissRegular, null)
            },
            elementType: 'span',
            renderByDefault: true
        }),
        expandIcon: _reactutilities.slot.optional(props.expandIcon, {
            renderByDefault: true,
            defaultProps: {
                'aria-disabled': disabled ? 'true' : undefined,
                'aria-expanded': open,
                children: /*#__PURE__*/ _react.createElement(_reacticons.ChevronDownRegular, null),
                role: 'button'
            },
            elementType: 'span'
        }),
        showClearIcon,
        activeDescendantController,
        ...baseState
    };
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    (0, _reactutilities.useOnClickOutside)({
        element: targetDocument,
        callback: (event)=>setOpen(event, false),
        refs: [
            triggerRef,
            comboboxPopupRef,
            comboboxTargetRef
        ],
        disabled: !open
    });
    /* handle open/close + focus change when clicking expandIcon */ const { onMouseDown: onIconMouseDown } = state.expandIcon || {};
    const onExpandIconMouseDown = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(onIconMouseDown, (event)=>{
        var _triggerRef_current;
        event.preventDefault();
        state.setOpen(event, !state.open);
        (_triggerRef_current = triggerRef.current) === null || _triggerRef_current === void 0 ? void 0 : _triggerRef_current.focus();
    }));
    if (state.expandIcon) {
        state.expandIcon.onMouseDown = onExpandIconMouseDown;
        // If there is no explicit aria-label, calculate default accName attribute for expandIcon button,
        // using the following steps:
        // 1. If there is an aria-label, it is "Open [aria-label]"
        // 2. If there is an aria-labelledby, it is "Open [aria-labelledby target]" (using aria-labelledby + ids)
        // 3. If there is no aria-label/ledby attr, it falls back to "Open"
        // We can't fall back to a label/htmlFor name because of https://github.com/w3c/accname/issues/179
        const hasExpandLabel = state.expandIcon['aria-label'] || state.expandIcon['aria-labelledby'];
        const defaultOpenString = 'Open'; // this is english-only since it is the fallback
        if (!hasExpandLabel) {
            if (props['aria-labelledby']) {
                var _state_expandIcon_id;
                const chevronId = (_state_expandIcon_id = state.expandIcon.id) !== null && _state_expandIcon_id !== void 0 ? _state_expandIcon_id : `${comboId}-chevron`;
                const chevronLabelledBy = `${chevronId} ${state.input['aria-labelledby']}`;
                state.expandIcon['aria-label'] = defaultOpenString;
                state.expandIcon.id = chevronId;
                state.expandIcon['aria-labelledby'] = chevronLabelledBy;
            } else if (props['aria-label']) {
                state.expandIcon['aria-label'] = `${defaultOpenString} ${props['aria-label']}`;
            } else {
                state.expandIcon['aria-label'] = defaultOpenString;
            }
        }
    }
    const onClearIconMouseDown = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)((_state_clearIcon = state.clearIcon) === null || _state_clearIcon === void 0 ? void 0 : _state_clearIcon.onMouseDown, (ev)=>{
        ev.preventDefault();
    }));
    const onClearIconClick = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)((_state_clearIcon1 = state.clearIcon) === null || _state_clearIcon1 === void 0 ? void 0 : _state_clearIcon1.onClick, (ev)=>{
        clearSelection(ev);
    }));
    if (state.clearIcon) {
        state.clearIcon.onMouseDown = onClearIconMouseDown;
        state.clearIcon.onClick = onClearIconClick;
    }
    // Heads up! We don't support "clearable" in multiselect mode, so we should never display a slot
    if (multiselect) {
        state.clearIcon = undefined;
    }
    if (process.env.NODE_ENV !== 'production') {
        // eslint-disable-next-line react-hooks/rules-of-hooks -- "process.env" does not change in runtime
        _react.useEffect(()=>{
            if (clearable && multiselect) {
                // eslint-disable-next-line no-console
                console.error(`[@fluentui/react-combobox] "clearable" prop is not supported in multiselect mode.`);
            }
        }, [
            clearable,
            multiselect
        ]);
    }
    return state;
};
