'use client';
import * as React from 'react';
import { createContext, useContextSelector } from '@fluentui/react-context-selector';
export const useColorPickerContextValues = (state)=>{
    const { color, shape, requestChange } = state;
    // This context is created with "@fluentui/react-context-selector", these is no sense to memoize it
    const colorPicker = {
        requestChange,
        color,
        shape
    };
    return {
        colorPicker
    };
};
export const colorPickerContextDefaultValue = {
    requestChange: ()=>{
    /*noop*/ },
    color: undefined,
    shape: 'rounded'
};
const colorPickerContext = createContext(undefined);
export const ColorPickerProvider = colorPickerContext.Provider;
export const useColorPickerContextValue_unstable = (selector)=>useContextSelector(colorPickerContext, (ctx = colorPickerContextDefaultValue)=>selector(ctx));
