'use client';
import { makeStyles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
export const colorPickerClassNames = {
    root: 'fui-ColorPicker'
};
/**
 * Styles for the root slot
 */ const useStyles = makeStyles({
    root: {
        display: 'flex',
        flexDirection: 'column',
        gap: tokens.spacingVerticalXS
    }
});
/**
 * Apply styling to the ColorPicker slots based on the state
 */ export const useColorPickerStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = mergeClasses(colorPickerClassNames.root, styles.root, state.root.className);
    return state;
};
