'use client';
import * as React from 'react';
import { getIntrinsicElementProps, slot, useEventCallback } from '@fluentui/react-utilities';
/**
 * Create the state required to render ColorPicker.
 *
 * The returned state can be modified with hooks such as useColorPickerStyles_unstable,
 * before being passed to renderColorPicker_unstable.
 *
 * @param props - props from this instance of ColorPicker
 * @param ref - reference to root HTMLDivElement of ColorPicker
 */ export const useColorPicker_unstable = (props, ref)=>{
    const { color, onColorChange, shape, ...rest } = props;
    const requestChange = useEventCallback((event, data)=>{
        onColorChange === null || onColorChange === void 0 ? void 0 : onColorChange(event, {
            type: 'change',
            event,
            color: data.color
        });
    });
    return {
        components: {
            root: 'div'
        },
        root: slot.always(getIntrinsicElementProps('div', {
            ref,
            ...rest
        }), {
            elementType: 'div'
        }),
        color,
        requestChange,
        shape
    };
};
