'use client';

import { __resetStyles, __styles, mergeClasses, shorthands } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { createFocusOutlineStyle } from '@fluentui/react-tabster';
export const colorAreaClassNames = {
  root: 'fui-ColorArea',
  thumb: 'fui-ColorArea__thumb',
  inputX: 'fui-ColorArea__inputX',
  inputY: 'fui-ColorArea__inputY'
};
export const colorAreaCSSVars = {
  areaXProgressVar: `--fui-AreaX--progress`,
  areaYProgressVar: `--fui-AreaY--progress`,
  thumbColorVar: `--fui-Area__thumb--color`,
  mainColorVar: `--fui-Area--main-color`
};
// Internal CSS variables
const thumbSizeVar = `--fui-Slider__thumb--size`;
/**
 * Styles for the root slot
 */
const useRootStyles = /*#__PURE__*/__resetStyles("r77w3t7", "r9og4es", [".r77w3t7{position:relative;border:1px solid var(--colorNeutralStroke1);background:linear-gradient(to bottom, transparent, #000),linear-gradient(to right, #fff, transparent),var(--fui-Area--main-color);forced-color-adjust:none;display:inline-grid;touch-action:none;align-items:start;justify-items:start;--fui-Slider__thumb--size:20px;min-width:300px;min-height:300px;box-sizing:border-box;margin-bottom:var(--spacingVerticalSNudge);}", ".r9og4es{position:relative;border:1px solid var(--colorNeutralStroke1);background:linear-gradient(to bottom, transparent, #000),linear-gradient(to left, #fff, transparent),var(--fui-Area--main-color);forced-color-adjust:none;display:inline-grid;touch-action:none;align-items:start;justify-items:start;--fui-Slider__thumb--size:20px;min-width:300px;min-height:300px;box-sizing:border-box;margin-bottom:var(--spacingVerticalSNudge);}"]);
/**
 * Styles for the thumb slot
 */
const useThumbStyles = /*#__PURE__*/__styles({
  thumb: {
    qhf8xq: "f1euv43f",
    a9b677: "f174ca62",
    Bqenvij: "f1yfdkfd",
    Bkecrkj: "f1aehjj5",
    oeaueh: "f1s6fcnf",
    Bvjb7m6: "fdgv6k0",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f44lkw9",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f1lvq45z",
    E5pizo: "f1whvlc6",
    De3pzq: "fqogvx2",
    Bz10aip: ["f1g1iug4", "f11okln6"],
    oyh7mz: ["f1r4bsg1", "fwsk87b"],
    B5kzvoi: "f1rtkqdg",
    Brfgrao: "f1j7ml58",
    lawp4y: 0,
    Fbdkly: 0,
    mdwyqc: 0,
    Bciustq: 0,
    gc50h5: "f1abv9ik",
    r59vdv: 0,
    Budzafs: 0,
    ck0cow: 0,
    n07z76: 0,
    Gng75u: "fielpny",
    Bcvre1j: "fyl8oag",
    Ftih45: "fzhtfnv",
    Bcgcnre: 0,
    Bqjgrrk: 0,
    qa3bma: 0,
    y0oebl: 0,
    Biqmznv: 0,
    Bm6vgfq: 0,
    Bbv0w2i: 0,
    uvfttm: 0,
    eqrjj: 0,
    Bk5zm6e: 0,
    m598lv: 0,
    B4f6apu: 0,
    ydt019: 0,
    Bq4z7u6: 0,
    Bdkvgpv: 0,
    B0qfbqy: 0,
    kj8mxx: "f3i7wkk"
  },
  focusIndicator: {
    Brovlpu: "ftqa4ok",
    B486eqv: "f2hkw1w",
    Bssx7fj: "f1b1k54r",
    uh7if5: ["f4ne723", "fqqcjud"],
    clntm0: "fh7aioi",
    Dlk2r6: ["fqqcjud", "f4ne723"],
    Bm3wd5j: "f1k55ka9",
    Bbrhkcr: ["fgclinu", "f16pcs8n"],
    f1oku: "fycbxed",
    aywvf2: ["f16pcs8n", "fgclinu"],
    B2j2mmj: "ffht0p2",
    wigs8: "f1p0ul1q",
    pbfy6t: "f1c901ms",
    B0v4ure: "f1alokd7",
    Byrf0fs: 0,
    Bsiemmq: 0,
    Bwckmig: 0,
    skfxo0: 0,
    Iidy0u: 0,
    B98u21t: 0,
    Bvwlmkc: 0,
    jo1ztg: 0,
    Ba1iezr: 0,
    Blmvk6g: 0,
    B24cy0v: 0,
    Bil7v7r: 0,
    Br3gin4: 0,
    nr063g: 0,
    ghq09: 0,
    Bbgo44z: 0,
    Bseh09z: "f1i978nd",
    az1dzo: 0,
    Ba3ybja: 0,
    B6352mv: 0,
    vppk2z: 0,
    Biaj6j7: "f16hcqkr",
    B2pnrqr: "f1tye2sp",
    B29w5g4: ["flw7qy0", "f1t01kh7"],
    Bhhzhcn: "frujvlw",
    Bec0n69: ["f1t01kh7", "flw7qy0"]
  }
}, {
  d: [".f1euv43f{position:absolute;}", ".f174ca62{width:var(--fui-Slider__thumb--size);}", ".f1yfdkfd{height:var(--fui-Slider__thumb--size);}", ".f1aehjj5{pointer-events:none;}", ".f1s6fcnf{outline-style:none;}", ".fdgv6k0{forced-color-adjust:none;}", [".f44lkw9{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], [".f1lvq45z{border:var(--strokeWidthThin) solid var(--colorNeutralForeground4);}", {
    p: -2
  }], ".f1whvlc6{box-shadow:var(--shadow4);}", ".fqogvx2{background-color:var(--fui-Area__thumb--color);}", ".f1g1iug4{transform:translate(-50%, 50%);}", ".f11okln6{transform:translate(50%, 50%);}", ".f1r4bsg1{left:var(--fui-AreaX--progress);}", ".fwsk87b{right:var(--fui-AreaX--progress);}", ".f1rtkqdg{bottom:var(--fui-AreaY--progress);}", ".f1j7ml58::before{position:absolute;}", [".f1abv9ik::before{inset:0px;}", {
    p: -1
  }], [".fielpny::before{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], ".fyl8oag::before{box-sizing:border-box;}", ".fzhtfnv::before{content:'';}", [".f3i7wkk::before{border:var(--strokeWidthThick) solid var(--colorNeutralBackground1);}", {
    p: -2
  }], ".f1b1k54r[data-fui-focus-within]:focus-within{border-top-color:transparent;}", ".f4ne723[data-fui-focus-within]:focus-within{border-right-color:transparent;}", ".fqqcjud[data-fui-focus-within]:focus-within{border-left-color:transparent;}", ".fh7aioi[data-fui-focus-within]:focus-within{border-bottom-color:transparent;}", ".ffht0p2[data-fui-focus-within]:focus-within::after{content:\"\";}", ".f1p0ul1q[data-fui-focus-within]:focus-within::after{position:absolute;}", ".f1c901ms[data-fui-focus-within]:focus-within::after{pointer-events:none;}", ".f1alokd7[data-fui-focus-within]:focus-within::after{z-index:1;}", [".f1i978nd[data-fui-focus-within]:focus-within::after{border:var(--strokeWidthThick) solid var(--colorStrokeFocus2);}", {
    p: -2
  }], [".f16hcqkr[data-fui-focus-within]:focus-within::after{border-radius:var(--borderRadiusCircular);}", {
    p: -1
  }], ".f1tye2sp[data-fui-focus-within]:focus-within::after{top:calc(var(--strokeWidthThick) * -1);}", ".flw7qy0[data-fui-focus-within]:focus-within::after{right:calc(var(--strokeWidthThick) * -1);}", ".f1t01kh7[data-fui-focus-within]:focus-within::after{left:calc(var(--strokeWidthThick) * -1);}", ".frujvlw[data-fui-focus-within]:focus-within::after{bottom:calc(var(--strokeWidthThick) * -1);}"],
  f: [".ftqa4ok:focus{outline-style:none;}"],
  i: [".f2hkw1w:focus-visible{outline-style:none;}"],
  m: [["@media (forced-colors: active){.f1k55ka9[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f16pcs8n[data-fui-focus-within]:focus-within::after{border-left-color:Highlight;}.fgclinu[data-fui-focus-within]:focus-within::after{border-right-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.fycbxed[data-fui-focus-within]:focus-within::after{border-bottom-color:Highlight;}}", {
    m: "(forced-colors: active)"
  }]]
});
/**
 * Styles for the Input slot
 */
const useInputStyles = /*#__PURE__*/__styles({
  input: {
    B68tc82: 0,
    Bmxbyg5: 0,
    Bpg54ce: "f1a3p1vp",
    qhf8xq: "f1euv43f",
    Bkecrkj: "f1aehjj5",
    Bhzewxz: "f15twtuk",
    oyh7mz: ["f1vgc2s3", "f1e31b4d"],
    abs64n: "fk73vx1",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1mk8lai",
    jrapky: 0,
    Frg6f3: 0,
    t21cq0: 0,
    B6of3ja: 0,
    B74szlk: "f1s184ao",
    a9b677: "fly5x3f",
    Bqenvij: "f1l02sjl"
  }
}, {
  d: [[".f1a3p1vp{overflow:hidden;}", {
    p: -1
  }], ".f1euv43f{position:absolute;}", ".f1aehjj5{pointer-events:none;}", ".f15twtuk{top:0;}", ".f1vgc2s3{left:0;}", ".f1e31b4d{right:0;}", ".fk73vx1{opacity:0;}", [".f1mk8lai{padding:0;}", {
    p: -1
  }], [".f1s184ao{margin:0;}", {
    p: -1
  }], ".fly5x3f{width:100%;}", ".f1l02sjl{height:100%;}"]
});
const useShapeStyles = /*#__PURE__*/__styles({
  rounded: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5"
  },
  square: {
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "f1fabniw"
  }
}, {
  d: [[".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f1fabniw{border-radius:var(--borderRadiusNone);}", {
    p: -1
  }]]
});
/**
 * Apply styling to the ColorArea slots based on the state
 */
export const useColorAreaStyles_unstable = state => {
  'use no memo';

  const rootStyles = useRootStyles();
  const thumbStyles = useThumbStyles();
  const inputStyles = useInputStyles();
  const shapeStyles = useShapeStyles();
  state.root.className = mergeClasses(colorAreaClassNames.root, rootStyles, shapeStyles[state.shape || 'rounded'], state.root.className);
  state.thumb.className = mergeClasses(colorAreaClassNames.thumb, thumbStyles.thumb, thumbStyles.focusIndicator, state.thumb.className);
  state.inputX.className = mergeClasses(colorAreaClassNames.inputX, inputStyles.input, state.inputX.className);
  state.inputY.className = mergeClasses(colorAreaClassNames.inputY, inputStyles.input, state.inputY.className);
  return state;
};