'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ColorPickerProvider: function() {
        return ColorPickerProvider;
    },
    colorPickerContextDefaultValue: function() {
        return colorPickerContextDefaultValue;
    },
    useColorPickerContextValue_unstable: function() {
        return useColorPickerContextValue_unstable;
    },
    useColorPickerContextValues: function() {
        return useColorPickerContextValues;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactcontextselector = require("@fluentui/react-context-selector");
const useColorPickerContextValues = (state)=>{
    const { color, shape, requestChange } = state;
    // This context is created with "@fluentui/react-context-selector", these is no sense to memoize it
    const colorPicker = {
        requestChange,
        color,
        shape
    };
    return {
        colorPicker
    };
};
const colorPickerContextDefaultValue = {
    requestChange: ()=>{
    /*noop*/ },
    color: undefined,
    shape: 'rounded'
};
const colorPickerContext = (0, _reactcontextselector.createContext)(undefined);
const ColorPickerProvider = colorPickerContext.Provider;
const useColorPickerContextValue_unstable = (selector)=>(0, _reactcontextselector.useContextSelector)(colorPickerContext, (ctx = colorPickerContextDefaultValue)=>selector(ctx));
