'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    colorSliderCSSVars: function() {
        return colorSliderCSSVars;
    },
    colorSliderClassNames: function() {
        return colorSliderClassNames;
    },
    useColorSliderStyles_unstable: function() {
        return useColorSliderStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const colorSliderClassNames = {
    root: 'fui-ColorSlider',
    rail: 'fui-ColorSlider__rail',
    thumb: 'fui-ColorSlider__thumb',
    input: 'fui-ColorSlider__input'
};
const colorSliderCSSVars = {
    sliderDirectionVar: `--fui-Slider--direction`,
    sliderProgressVar: `--fui-Slider--progress`,
    thumbColorVar: `--fui-Slider__thumb--color`,
    railColorVar: `--fui-Slider__rail--color`,
    thumbSizeVar: `--fui-Slider__thumb--size`,
    railSizeVar: `--fui-Slider__rail--size`
};
const hueBackground = `linear-gradient(${[
    `var(${colorSliderCSSVars.sliderDirectionVar})`,
    'red',
    'fuchsia',
    'blue',
    'aqua',
    'lime',
    'yellow',
    'red'
].join(',')})`;
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeResetStyles)({
    position: 'relative',
    display: 'inline-grid',
    touchAction: 'none',
    alignItems: 'center',
    justifyItems: 'center',
    [colorSliderCSSVars.thumbSizeVar]: '20px',
    [colorSliderCSSVars.railSizeVar]: '20px',
    minHeight: '32px'
});
const useStyles = (0, _react.makeStyles)({
    horizontal: {
        minWidth: '200px',
        // 3x3 grid with the rail and thumb in the center cell [2,2] and the hidden input stretching across all cells
        gridTemplateRows: `1fr var(${colorSliderCSSVars.thumbSizeVar}) 1fr`,
        gridTemplateColumns: `1fr 100% 1fr`
    },
    vertical: {
        minHeight: '280px',
        // 3x3 grid with the rail and thumb in the center cell [2,2] and the hidden input stretching across all cells
        gridTemplateRows: `1fr 100% 1fr`,
        gridTemplateColumns: `1fr var(${colorSliderCSSVars.thumbSizeVar}) 1fr`
    }
});
const useChannelStyles = (0, _react.makeStyles)({
    hue: {
        backgroundImage: hueBackground
    },
    saturation: {
        backgroundImage: `linear-gradient(to right, #808080, var(${colorSliderCSSVars.railColorVar}))`
    },
    value: {
        backgroundImage: `linear-gradient(to right, #000, var(${colorSliderCSSVars.railColorVar}))`
    }
});
/**
 * Styles for the rail slot
 */ const useRailStyles = (0, _react.makeStyles)({
    rail: {
        pointerEvents: 'none',
        gridRowStart: '2',
        gridRowEnd: '2',
        gridColumnStart: '2',
        gridColumnEnd: '2',
        position: 'relative',
        forcedColorAdjust: 'none',
        outlineWidth: '1px',
        outlineStyle: 'solid',
        outlineColor: _reacttheme.tokens.colorTransparentStroke,
        '::before': {
            content: "''",
            position: 'absolute'
        }
    },
    horizontal: {
        width: '100%',
        height: `var(${colorSliderCSSVars.railSizeVar})`,
        '::before': {
            left: '-1px',
            right: '-1px',
            height: `var(${colorSliderCSSVars.railSizeVar})`
        }
    },
    vertical: {
        width: `var(${colorSliderCSSVars.railSizeVar})`,
        height: '100%',
        '::before': {
            width: `var(${colorSliderCSSVars.railSizeVar})`,
            top: '-1px',
            bottom: '1px'
        }
    }
});
/**
 * Styles for the thumb slot
 */ const useThumbStyles = (0, _react.makeStyles)({
    thumb: {
        gridRowStart: '2',
        gridRowEnd: '2',
        gridColumnStart: '2',
        gridColumnEnd: '2',
        position: 'absolute',
        width: `var(${colorSliderCSSVars.thumbSizeVar})`,
        height: `var(${colorSliderCSSVars.thumbSizeVar})`,
        pointerEvents: 'none',
        outlineStyle: 'none',
        forcedColorAdjust: 'none',
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralForeground4}`,
        boxShadow: _reacttheme.tokens.shadow4,
        backgroundColor: `var(${colorSliderCSSVars.thumbColorVar})`,
        '::before': {
            position: 'absolute',
            inset: '0px',
            borderRadius: _reacttheme.tokens.borderRadiusCircular,
            boxSizing: 'border-box',
            content: "''",
            border: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorNeutralBackground1}`
        }
    },
    horizontal: {
        transform: 'translateX(-50%)',
        left: `var(${colorSliderCSSVars.sliderProgressVar})`
    },
    vertical: {
        transform: 'translateY(50%)',
        bottom: `var(${colorSliderCSSVars.sliderProgressVar})`
    }
});
const useShapeStyles = (0, _react.makeStyles)({
    rounded: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium
    },
    square: {
        borderRadius: _reacttheme.tokens.borderRadiusNone
    }
});
/**
 * Styles for the Input slot
 */ const useInputStyles = (0, _react.makeStyles)({
    input: {
        cursor: 'pointer',
        opacity: 0,
        gridRowStart: '1',
        gridRowEnd: '-1',
        gridColumnStart: '1',
        gridColumnEnd: '-1',
        padding: '0',
        margin: '0',
        [`:focus-visible ~ .${colorSliderClassNames.thumb}`]: {
            border: `2px solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorTransparentStroke}`,
            borderRadius: _reacttheme.tokens.borderRadiusCircular
        }
    },
    horizontal: {
        height: `var(${colorSliderCSSVars.thumbSizeVar})`,
        width: '100%'
    },
    vertical: {
        height: '100%',
        width: `var(${colorSliderCSSVars.thumbSizeVar})`,
        'writing-mode': 'vertical-lr',
        direction: 'rtl'
    }
});
const useColorSliderStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const styles = useStyles();
    const railStyles = useRailStyles();
    const thumbStyles = useThumbStyles();
    const inputStyles = useInputStyles();
    const shapeStyles = useShapeStyles();
    const channelStyles = useChannelStyles();
    const isVertical = state.vertical;
    state.root.className = (0, _react.mergeClasses)(colorSliderClassNames.root, rootStyles, isVertical ? styles.vertical : styles.horizontal, state.root.className);
    state.rail.className = (0, _react.mergeClasses)(colorSliderClassNames.rail, railStyles.rail, channelStyles[state.channel || 'hue'], shapeStyles[state.shape || 'rounded'], isVertical ? railStyles.vertical : railStyles.horizontal, state.rail.className);
    state.thumb.className = (0, _react.mergeClasses)(colorSliderClassNames.thumb, thumbStyles.thumb, isVertical ? thumbStyles.vertical : thumbStyles.horizontal, state.thumb.className);
    state.input.className = (0, _react.mergeClasses)(colorSliderClassNames.input, inputStyles.input, isVertical ? inputStyles.vertical : inputStyles.horizontal, state.input.className);
    return state;
};
