'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    colorSliderCSSVars: function() {
        return colorSliderCSSVars;
    },
    colorSliderClassNames: function() {
        return colorSliderClassNames;
    },
    useColorSliderStyles_unstable: function() {
        return useColorSliderStyles_unstable;
    }
});
const _react = require("@griffel/react");
const colorSliderClassNames = {
    root: 'fui-ColorSlider',
    rail: 'fui-ColorSlider__rail',
    thumb: 'fui-ColorSlider__thumb',
    input: 'fui-ColorSlider__input'
};
const colorSliderCSSVars = {
    sliderDirectionVar: `--fui-Slider--direction`,
    sliderProgressVar: `--fui-Slider--progress`,
    thumbColorVar: `--fui-Slider__thumb--color`,
    railColorVar: `--fui-Slider__rail--color`,
    thumbSizeVar: `--fui-Slider__thumb--size`,
    railSizeVar: `--fui-Slider__rail--size`
};
const hueBackground = `linear-gradient(${[
    `var(${colorSliderCSSVars.sliderDirectionVar})`,
    'red',
    'fuchsia',
    'blue',
    'aqua',
    'lime',
    'yellow',
    'red'
].join(',')})`;
/**
 * Styles for the root slot
 */ const useRootStyles = /*#__PURE__*/ (0, _react.__resetStyles)("r1j9hj9j", null, [
    ".r1j9hj9j{position:relative;display:inline-grid;touch-action:none;align-items:center;justify-items:center;--fui-Slider__thumb--size:20px;--fui-Slider__rail--size:20px;min-height:32px;}"
]);
const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    horizontal: {
        Bf4jedk: "f93ek0f",
        wkccdc: "fgfd48t",
        Budl1dq: "f11e9psi"
    },
    vertical: {
        sshi5w: "fwwq4i4",
        wkccdc: "fqcvrs3",
        Budl1dq: "fiadc6h"
    }
}, {
    d: [
        ".f93ek0f{min-width:200px;}",
        ".fgfd48t{grid-template-rows:1fr var(--fui-Slider__thumb--size) 1fr;}",
        ".f11e9psi{grid-template-columns:1fr 100% 1fr;}",
        ".fwwq4i4{min-height:280px;}",
        ".fqcvrs3{grid-template-rows:1fr 100% 1fr;}",
        ".fiadc6h{grid-template-columns:1fr var(--fui-Slider__thumb--size) 1fr;}"
    ]
});
const useChannelStyles = /*#__PURE__*/ (0, _react.__styles)({
    hue: {
        Bcmaq0h: "f1curpo1"
    },
    saturation: {
        Bcmaq0h: [
            "fdhcg5e",
            "f1onqon0"
        ]
    },
    value: {
        Bcmaq0h: [
            "f1r1ueul",
            "fbtriqu"
        ]
    }
}, {
    d: [
        ".f1curpo1{background-image:linear-gradient(var(--fui-Slider--direction),red,fuchsia,blue,aqua,lime,yellow,red);}",
        ".fdhcg5e{background-image:linear-gradient(to right, #808080, var(--fui-Slider__rail--color));}",
        ".f1onqon0{background-image:linear-gradient(to left, #808080, var(--fui-Slider__rail--color));}",
        ".f1r1ueul{background-image:linear-gradient(to right, #000, var(--fui-Slider__rail--color));}",
        ".fbtriqu{background-image:linear-gradient(to left, #000, var(--fui-Slider__rail--color));}"
    ]
});
/**
 * Styles for the rail slot
 */ const useRailStyles = /*#__PURE__*/ (0, _react.__styles)({
    rail: {
        Bkecrkj: "f1aehjj5",
        Ijaq50: "faunodf",
        nk6f5a: "f88nxoq",
        Br312pm: "fd46tj4",
        Bw0ie65: "f1e2fz10",
        qhf8xq: "f10pi13n",
        Bvjb7m6: "fdgv6k0",
        Bpd4iqm: "fpvhumw",
        oeaueh: "f1yog68k",
        Bw0xxkn: "f13sgyd8",
        Ftih45: "fzhtfnv",
        Brfgrao: "f1j7ml58"
    },
    horizontal: {
        a9b677: "fly5x3f",
        Bqenvij: "f1cy86ho",
        Fbdkly: [
            "f1heqfse",
            "fkh49vu"
        ],
        mdwyqc: [
            "fkh49vu",
            "f1heqfse"
        ],
        Baz25je: "f16tdq4e"
    },
    vertical: {
        a9b677: "fqxfnkd",
        Bqenvij: "f1l02sjl",
        Ccq8qp: "f1rik0od",
        Bciustq: "f14xwovp",
        lawp4y: "febq2dz"
    }
}, {
    d: [
        ".f1aehjj5{pointer-events:none;}",
        ".faunodf{grid-row-start:2;}",
        ".f88nxoq{grid-row-end:2;}",
        ".fd46tj4{grid-column-start:2;}",
        ".f1e2fz10{grid-column-end:2;}",
        ".f10pi13n{position:relative;}",
        ".fdgv6k0{forced-color-adjust:none;}",
        ".fpvhumw{outline-width:1px;}",
        ".f1yog68k{outline-style:solid;}",
        ".f13sgyd8{outline-color:var(--colorTransparentStroke);}",
        ".fzhtfnv::before{content:'';}",
        ".f1j7ml58::before{position:absolute;}",
        ".fly5x3f{width:100%;}",
        ".f1cy86ho{height:var(--fui-Slider__rail--size);}",
        ".f1heqfse::before{left:-1px;}",
        ".fkh49vu::before{right:-1px;}",
        ".f16tdq4e::before{height:var(--fui-Slider__rail--size);}",
        ".fqxfnkd{width:var(--fui-Slider__rail--size);}",
        ".f1l02sjl{height:100%;}",
        ".f1rik0od::before{width:var(--fui-Slider__rail--size);}",
        ".f14xwovp::before{top:-1px;}",
        ".febq2dz::before{bottom:1px;}"
    ]
});
/**
 * Styles for the thumb slot
 */ const useThumbStyles = /*#__PURE__*/ (0, _react.__styles)({
    thumb: {
        Ijaq50: "faunodf",
        nk6f5a: "f88nxoq",
        Br312pm: "fd46tj4",
        Bw0ie65: "f1e2fz10",
        qhf8xq: "f1euv43f",
        a9b677: "f174ca62",
        Bqenvij: "f1yfdkfd",
        Bkecrkj: "f1aehjj5",
        oeaueh: "f1s6fcnf",
        Bvjb7m6: "fdgv6k0",
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "f44lkw9",
        Bgfg5da: 0,
        B9xav0g: 0,
        oivjwe: 0,
        Bn0qgzm: 0,
        B4g9neb: 0,
        zhjwy3: 0,
        wvpqe5: 0,
        ibv6hh: 0,
        u1mtju: 0,
        h3c5rm: 0,
        vrafjx: 0,
        Bekrc4i: 0,
        i8vvqc: 0,
        g2u3we: 0,
        icvyot: 0,
        B4j52fo: 0,
        irswps: "f1lvq45z",
        E5pizo: "f1whvlc6",
        De3pzq: "foksa45",
        Brfgrao: "f1j7ml58",
        lawp4y: 0,
        Fbdkly: 0,
        mdwyqc: 0,
        Bciustq: 0,
        gc50h5: "f1abv9ik",
        r59vdv: 0,
        Budzafs: 0,
        ck0cow: 0,
        n07z76: 0,
        Gng75u: "fielpny",
        Bcvre1j: "fyl8oag",
        Ftih45: "fzhtfnv",
        Bcgcnre: 0,
        Bqjgrrk: 0,
        qa3bma: 0,
        y0oebl: 0,
        Biqmznv: 0,
        Bm6vgfq: 0,
        Bbv0w2i: 0,
        uvfttm: 0,
        eqrjj: 0,
        Bk5zm6e: 0,
        m598lv: 0,
        B4f6apu: 0,
        ydt019: 0,
        Bq4z7u6: 0,
        Bdkvgpv: 0,
        B0qfbqy: 0,
        kj8mxx: "f3i7wkk"
    },
    horizontal: {
        Bz10aip: [
            "f13gfj74",
            "f1nfknbn"
        ],
        oyh7mz: [
            "f1fj3zth",
            "fcf9u6w"
        ]
    },
    vertical: {
        Bz10aip: "f5cv5a3",
        B5kzvoi: "feeniun"
    }
}, {
    d: [
        ".faunodf{grid-row-start:2;}",
        ".f88nxoq{grid-row-end:2;}",
        ".fd46tj4{grid-column-start:2;}",
        ".f1e2fz10{grid-column-end:2;}",
        ".f1euv43f{position:absolute;}",
        ".f174ca62{width:var(--fui-Slider__thumb--size);}",
        ".f1yfdkfd{height:var(--fui-Slider__thumb--size);}",
        ".f1aehjj5{pointer-events:none;}",
        ".f1s6fcnf{outline-style:none;}",
        ".fdgv6k0{forced-color-adjust:none;}",
        [
            ".f44lkw9{border-radius:var(--borderRadiusCircular);}",
            {
                p: -1
            }
        ],
        [
            ".f1lvq45z{border:var(--strokeWidthThin) solid var(--colorNeutralForeground4);}",
            {
                p: -2
            }
        ],
        ".f1whvlc6{box-shadow:var(--shadow4);}",
        ".foksa45{background-color:var(--fui-Slider__thumb--color);}",
        ".f1j7ml58::before{position:absolute;}",
        [
            ".f1abv9ik::before{inset:0px;}",
            {
                p: -1
            }
        ],
        [
            ".fielpny::before{border-radius:var(--borderRadiusCircular);}",
            {
                p: -1
            }
        ],
        ".fyl8oag::before{box-sizing:border-box;}",
        ".fzhtfnv::before{content:'';}",
        [
            ".f3i7wkk::before{border:var(--strokeWidthThick) solid var(--colorNeutralBackground1);}",
            {
                p: -2
            }
        ],
        ".f13gfj74{transform:translateX(-50%);}",
        ".f1nfknbn{transform:translateX(50%);}",
        ".f1fj3zth{left:var(--fui-Slider--progress);}",
        ".fcf9u6w{right:var(--fui-Slider--progress);}",
        ".f5cv5a3{transform:translateY(50%);}",
        ".feeniun{bottom:var(--fui-Slider--progress);}"
    ]
});
const useShapeStyles = /*#__PURE__*/ (0, _react.__styles)({
    rounded: {
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "ft85np5"
    },
    square: {
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "f1fabniw"
    }
}, {
    d: [
        [
            ".ft85np5{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        [
            ".f1fabniw{border-radius:var(--borderRadiusNone);}",
            {
                p: -1
            }
        ]
    ]
});
/**
 * Styles for the Input slot
 */ const useInputStyles = /*#__PURE__*/ (0, _react.__styles)({
    input: {
        Bceei9c: "f1k6fduh",
        abs64n: "fk73vx1",
        Ijaq50: "f16hsg94",
        nk6f5a: "f1nzqi2z",
        Br312pm: "fwpfdsa",
        Bw0ie65: "fuur7zz",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: "f1mk8lai",
        jrapky: 0,
        Frg6f3: 0,
        t21cq0: 0,
        B6of3ja: 0,
        B74szlk: "f1s184ao",
        jo39rj: 0,
        C5zqim: 0,
        Bdlbwnu: 0,
        B8rk77i: 0,
        Bbzx7hc: 0,
        Hwkvcz: 0,
        B0nnt1c: 0,
        Brwsv5j: 0,
        B2b7vog: 0,
        B4hmq5e: 0,
        B8jxwem: 0,
        B18nadz: 0,
        Ddg5ig: 0,
        Byj09el: 0,
        Dac2s3: 0,
        Dd2y6r: 0,
        Bk0t58e: "f1nq8t98",
        Ewenww: 0,
        Brqi8qb: 0,
        zz3kca: 0,
        low6xx: "fjt56wq",
        d0s10n: 0,
        wea7l5: 0,
        olu5tv: 0,
        g5nsvh: 0,
        Bqvnfwh: "f1n9m442"
    },
    horizontal: {
        Bqenvij: "f1yfdkfd",
        a9b677: "fly5x3f"
    },
    vertical: {
        Bqenvij: "f1l02sjl",
        a9b677: "f174ca62",
        Biqzhck: "f1r7j8g6",
        kgocjf: [
            "f1va4sj6",
            "f1r2v9sp"
        ]
    }
}, {
    d: [
        ".f1k6fduh{cursor:pointer;}",
        ".fk73vx1{opacity:0;}",
        ".f16hsg94{grid-row-start:1;}",
        ".f1nzqi2z{grid-row-end:-1;}",
        ".fwpfdsa{grid-column-start:1;}",
        ".fuur7zz{grid-column-end:-1;}",
        [
            ".f1mk8lai{padding:0;}",
            {
                p: -1
            }
        ],
        [
            ".f1s184ao{margin:0;}",
            {
                p: -1
            }
        ],
        ".f1yfdkfd{height:var(--fui-Slider__thumb--size);}",
        ".fly5x3f{width:100%;}",
        ".f1l02sjl{height:100%;}",
        ".f174ca62{width:var(--fui-Slider__thumb--size);}",
        ".f1r7j8g6{writing-mode:vertical-lr;}",
        ".f1va4sj6{direction:rtl;}",
        ".f1r2v9sp{direction:ltr;}"
    ],
    i: [
        [
            ".f1nq8t98:focus-visible~.fui-ColorSlider__thumb{border:2px solid var(--colorStrokeFocus2);}",
            {
                p: -2
            }
        ],
        [
            ".fjt56wq:focus-visible~.fui-ColorSlider__thumb{outline:var(--strokeWidthThick) solid var(--colorTransparentStroke);}",
            {
                p: -1
            }
        ],
        [
            ".f1n9m442:focus-visible~.fui-ColorSlider__thumb{border-radius:var(--borderRadiusCircular);}",
            {
                p: -1
            }
        ]
    ]
});
const useColorSliderStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const styles = useStyles();
    const railStyles = useRailStyles();
    const thumbStyles = useThumbStyles();
    const inputStyles = useInputStyles();
    const shapeStyles = useShapeStyles();
    const channelStyles = useChannelStyles();
    const isVertical = state.vertical;
    state.root.className = (0, _react.mergeClasses)(colorSliderClassNames.root, rootStyles, isVertical ? styles.vertical : styles.horizontal, state.root.className);
    state.rail.className = (0, _react.mergeClasses)(colorSliderClassNames.rail, railStyles.rail, channelStyles[state.channel || 'hue'], shapeStyles[state.shape || 'rounded'], isVertical ? railStyles.vertical : railStyles.horizontal, state.rail.className);
    state.thumb.className = (0, _react.mergeClasses)(colorSliderClassNames.thumb, thumbStyles.thumb, isVertical ? thumbStyles.vertical : thumbStyles.horizontal, state.thumb.className);
    state.input.className = (0, _react.mergeClasses)(colorSliderClassNames.input, inputStyles.input, isVertical ? inputStyles.vertical : inputStyles.horizontal, state.input.className);
    return state;
};
