'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useColorSlider_unstable", {
    enumerable: true,
    get: function() {
        return useColorSlider_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _tinycolor = require("@ctrl/tinycolor");
const _reactutilities = require("@fluentui/react-utilities");
const _useColorSliderStylesstyles = require("./useColorSliderStyles.styles");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _colorPicker = require("../../contexts/colorPicker");
const _constants = require("../../utils/constants");
const _getPercent = require("../../utils/getPercent");
const _createHsvColor = require("../../utils/createHsvColor");
const _adjustChannel = require("../../utils/adjustChannel");
const useColorSlider_unstable = (props, ref)=>{
    'use no memo';
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const onChangeFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.requestChange);
    const colorFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.color);
    const shapeFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.shape);
    const nativeProps = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'input',
        excludedPropNames: [
            'onChange',
            'color'
        ]
    });
    const { color, channel = 'hue', onChange = onChangeFromContext, shape = shapeFromContext, vertical, root, input, rail, thumb } = props;
    const hsvColor = color || colorFromContext;
    const hslColor = (0, _tinycolor.tinycolor)(hsvColor).toHsl();
    const [currentColor, setCurrentColor] = (0, _reactutilities.useControllableState)({
        defaultState: props.defaultColor,
        state: hsvColor,
        initialState: _constants.INITIAL_COLOR_HSV
    });
    const MAX = channel === 'hue' ? _constants.HUE_MAX : _constants.MAX;
    const valueChannelActions = {
        hue: (0, _adjustChannel.clampValue)(currentColor.h),
        saturation: (0, _adjustChannel.clampValue)(currentColor.s * 100),
        value: (0, _adjustChannel.clampValue)(currentColor.v * 100)
    };
    const clampedValue = (0, _adjustChannel.adjustChannel)(channel, valueChannelActions);
    const valuePercent = (0, _getPercent.getPercent)(clampedValue, _constants.MIN, MAX);
    const inputOnChange = input === null || input === void 0 ? void 0 : input.onChange;
    const _onChange = (0, _reactutilities.useEventCallback)((event)=>{
        const newValue = Number(event.target.value);
        const colorActions = {
            hue: ()=>(0, _createHsvColor.createHsvColor)({
                    ...hsvColor,
                    h: newValue
                }),
            saturation: ()=>(0, _createHsvColor.createHsvColor)({
                    ...hsvColor,
                    s: newValue / 100
                }),
            value: ()=>(0, _createHsvColor.createHsvColor)({
                    ...hsvColor,
                    v: newValue / 100
                })
        };
        const newColor = (0, _adjustChannel.adjustChannel)(channel, colorActions)();
        setCurrentColor(newColor);
        inputOnChange === null || inputOnChange === void 0 ? void 0 : inputOnChange(event);
        onChange === null || onChange === void 0 ? void 0 : onChange(event, {
            type: 'change',
            event,
            color: newColor
        });
    });
    const rootVariables = {
        [_useColorSliderStylesstyles.colorSliderCSSVars.sliderDirectionVar]: vertical ? '180deg' : dir === 'ltr' ? '-90deg' : '90deg',
        [_useColorSliderStylesstyles.colorSliderCSSVars.sliderProgressVar]: `${valuePercent}%`,
        [_useColorSliderStylesstyles.colorSliderCSSVars.thumbColorVar]: channel === 'hue' ? `hsl(${clampedValue}, 100%, 50%)` : (0, _tinycolor.tinycolor)(hsvColor).toRgbString(),
        [_useColorSliderStylesstyles.colorSliderCSSVars.railColorVar]: channel === 'hue' ? `hsl(${hslColor.h} ${hslColor.s * 100}%, ${hslColor.l * 100}%)` : `hsl(${hslColor.h} 100%, 50%)`
    };
    const state = {
        shape,
        vertical,
        channel,
        components: {
            input: 'input',
            rail: 'div',
            root: 'div',
            thumb: 'div'
        },
        root: _reactutilities.slot.always(root, {
            defaultProps: {
                role: 'group',
                ...nativeProps.root
            },
            elementType: 'div'
        }),
        input: _reactutilities.slot.always(input, {
            defaultProps: {
                id: (0, _reactutilities.useId)('slider-', props.id),
                ref,
                min: _constants.MIN,
                max: MAX,
                tabIndex: 0,
                ['aria-orientation']: vertical ? 'vertical' : 'horizontal',
                ...nativeProps.primary,
                type: 'range'
            },
            elementType: 'input'
        }),
        rail: _reactutilities.slot.always(rail, {
            elementType: 'div'
        }),
        thumb: _reactutilities.slot.always(thumb, {
            elementType: 'div'
        })
    };
    // Root props
    state.root.style = {
        ...rootVariables,
        ...state.root.style
    };
    // Input Props
    state.input.value = clampedValue;
    state.input.onChange = _onChange;
    return state;
};
