'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    colorAreaCSSVars: function() {
        return colorAreaCSSVars;
    },
    colorAreaClassNames: function() {
        return colorAreaClassNames;
    },
    useColorAreaStyles_unstable: function() {
        return useColorAreaStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const colorAreaClassNames = {
    root: 'fui-ColorArea',
    thumb: 'fui-ColorArea__thumb',
    inputX: 'fui-ColorArea__inputX',
    inputY: 'fui-ColorArea__inputY'
};
const colorAreaCSSVars = {
    areaXProgressVar: `--fui-AreaX--progress`,
    areaYProgressVar: `--fui-AreaY--progress`,
    thumbColorVar: `--fui-Area__thumb--color`,
    mainColorVar: `--fui-Area--main-color`
};
// Internal CSS variables
const thumbSizeVar = `--fui-Slider__thumb--size`;
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeResetStyles)({
    position: 'relative',
    border: `1px solid ${_reacttheme.tokens.colorNeutralStroke1}`,
    background: `linear-gradient(to bottom, transparent, #000), linear-gradient(to right, #fff, transparent), var(${colorAreaCSSVars.mainColorVar})`,
    forcedColorAdjust: 'none',
    display: 'inline-grid',
    touchAction: 'none',
    alignItems: 'start',
    justifyItems: 'start',
    [thumbSizeVar]: '20px',
    minWidth: '300px',
    minHeight: '300px',
    boxSizing: 'border-box',
    marginBottom: _reacttheme.tokens.spacingVerticalSNudge
});
/**
 * Styles for the thumb slot
 */ const useThumbStyles = (0, _react.makeStyles)({
    thumb: {
        position: 'absolute',
        width: `var(${thumbSizeVar})`,
        height: `var(${thumbSizeVar})`,
        pointerEvents: 'none',
        outlineStyle: 'none',
        forcedColorAdjust: 'none',
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        border: `${_reacttheme.tokens.strokeWidthThin} solid ${_reacttheme.tokens.colorNeutralForeground4}`,
        boxShadow: _reacttheme.tokens.shadow4,
        backgroundColor: `var(${colorAreaCSSVars.thumbColorVar})`,
        transform: 'translate(-50%, 50%)',
        left: `var(${colorAreaCSSVars.areaXProgressVar})`,
        bottom: `var(${colorAreaCSSVars.areaYProgressVar})`,
        '::before': {
            position: 'absolute',
            inset: '0px',
            borderRadius: _reacttheme.tokens.borderRadiusCircular,
            boxSizing: 'border-box',
            content: "''",
            border: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorNeutralBackground1}`
        }
    },
    focusIndicator: (0, _reacttabster.createFocusOutlineStyle)({
        selector: 'focus-within',
        style: {
            outlineWidth: _reacttheme.tokens.strokeWidthThick,
            ..._react.shorthands.borderWidth(_reacttheme.tokens.strokeWidthThick),
            outlineRadius: _reacttheme.tokens.borderRadiusCircular
        }
    })
});
/**
 * Styles for the Input slot
 */ const useInputStyles = (0, _react.makeStyles)({
    input: {
        overflow: 'hidden',
        position: 'absolute',
        pointerEvents: 'none',
        top: 0,
        left: 0,
        opacity: 0,
        padding: '0',
        margin: '0',
        width: '100%',
        height: '100%'
    }
});
const useShapeStyles = (0, _react.makeStyles)({
    rounded: {
        borderRadius: _reacttheme.tokens.borderRadiusMedium
    },
    square: {
        borderRadius: _reacttheme.tokens.borderRadiusNone
    }
});
const useColorAreaStyles_unstable = (state)=>{
    'use no memo';
    const rootStyles = useRootStyles();
    const thumbStyles = useThumbStyles();
    const inputStyles = useInputStyles();
    const shapeStyles = useShapeStyles();
    state.root.className = (0, _react.mergeClasses)(colorAreaClassNames.root, rootStyles, shapeStyles[state.shape || 'rounded'], state.root.className);
    state.thumb.className = (0, _react.mergeClasses)(colorAreaClassNames.thumb, thumbStyles.thumb, thumbStyles.focusIndicator, state.thumb.className);
    state.inputX.className = (0, _react.mergeClasses)(colorAreaClassNames.inputX, inputStyles.input, state.inputX.className);
    state.inputY.className = (0, _react.mergeClasses)(colorAreaClassNames.inputY, inputStyles.input, state.inputY.className);
    return state;
};
