'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useColorArea_unstable", {
    enumerable: true,
    get: function() {
        return useColorArea_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _tinycolor = require("@ctrl/tinycolor");
const _reactutilities = require("@fluentui/react-utilities");
const _useColorAreaStylesstyles = require("./useColorAreaStyles.styles");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reacttabster = require("@fluentui/react-tabster");
const _constants = require("../../utils/constants");
const _getCoordinates = require("../../utils/getCoordinates");
const _colorPicker = require("../../contexts/colorPicker");
const useColorArea_unstable = (props, ref)=>{
    const { targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const rootRef = _react.useRef(null);
    const xRef = _react.useRef(null);
    const yRef = _react.useRef(null);
    const focusWithinRef = (0, _reacttabster.useFocusWithin)();
    const onChangeFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.requestChange);
    const colorFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.color);
    const shapeFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.shape);
    const { onChange = onChangeFromContext, shape = shapeFromContext, inputX, inputY, thumb, color, ...rest } = props;
    const [hsvColor, setColor] = (0, _reactutilities.useControllableState)({
        defaultState: props.defaultColor,
        state: color || colorFromContext,
        initialState: _constants.INITIAL_COLOR_HSV
    });
    const saturation = Math.round(hsvColor.s * 100);
    const value = Math.round(hsvColor.v * 100);
    const [activeAxis, setActiveAxis] = _react.useState(null);
    const requestColorChange = (0, _reactutilities.useEventCallback)((event)=>{
        if (!rootRef.current) {
            return;
        }
        const coordinates = (0, _getCoordinates.getCoordinates)(rootRef.current, event);
        const newColor = {
            ...hsvColor,
            s: coordinates.x,
            v: coordinates.y
        };
        setColor(newColor);
        onChange === null || onChange === void 0 ? void 0 : onChange(event, {
            type: 'change',
            event,
            color: newColor
        });
    });
    const handleDocumentPointerMove = _react.useCallback((event)=>{
        requestColorChange(event);
    }, [
        requestColorChange
    ]);
    const handleDocumentPointerUp = (0, _reactutilities.useEventCallback)(()=>{
        targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.removeEventListener('pointermove', handleDocumentPointerMove);
    });
    const handleRootOnPointerDown = (0, _reactutilities.useEventCallback)((event)=>{
        event.stopPropagation();
        event.preventDefault();
        requestColorChange(event.nativeEvent);
        targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.addEventListener('pointermove', handleDocumentPointerMove);
        targetDocument === null || targetDocument === void 0 ? void 0 : targetDocument.addEventListener('pointerup', handleDocumentPointerUp, {
            once: true
        });
    });
    const handleInputOnChange = (0, _reactutilities.useEventCallback)((event)=>{
        const targetValue = Number(event.target.value) / 100;
        const newColor = {
            ...hsvColor,
            ...event.target === xRef.current && {
                s: targetValue
            },
            ...event.target === yRef.current && {
                v: targetValue
            }
        };
        setColor(newColor);
        onChange === null || onChange === void 0 ? void 0 : onChange(event, {
            type: 'change',
            event,
            color: newColor
        });
    });
    const handleRootOnKeyDown = (0, _reactutilities.useEventCallback)((event)=>{
        let deltaX = 0;
        let deltaY = 0;
        let axis = 'x';
        switch(event.key){
            case 'ArrowUp':
                event.preventDefault();
                axis = 'y';
                deltaY = 1;
                break;
            case 'ArrowDown':
                event.preventDefault();
                axis = 'y';
                deltaY = -1;
                break;
            case 'ArrowLeft':
                event.preventDefault();
                axis = 'x';
                deltaX = -1;
                break;
            case 'ArrowRight':
                event.preventDefault();
                axis = 'x';
                deltaX = 1;
                break;
        }
        if (deltaX === 0 && deltaY === 0) {
            return;
        }
        const newColor = {
            ...hsvColor,
            s: Math.min(Math.max(hsvColor.s + deltaX / 100, 0), 1),
            v: Math.min(Math.max(hsvColor.v + deltaY / 100, 0), 1)
        };
        setColor(newColor);
        setActiveAxis(axis);
        onChange === null || onChange === void 0 ? void 0 : onChange(event, {
            type: 'change',
            event,
            color: newColor
        });
    });
    const rootVariables = {
        [_useColorAreaStylesstyles.colorAreaCSSVars.areaXProgressVar]: `${saturation}%`,
        [_useColorAreaStylesstyles.colorAreaCSSVars.areaYProgressVar]: `${value}%`,
        [_useColorAreaStylesstyles.colorAreaCSSVars.thumbColorVar]: (0, _tinycolor.tinycolor)(hsvColor).toRgbString(),
        [_useColorAreaStylesstyles.colorAreaCSSVars.mainColorVar]: `hsl(${hsvColor.h}, 100%, 50%)`
    };
    const state = {
        shape,
        components: {
            inputX: 'input',
            inputY: 'input',
            root: 'div',
            thumb: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            ...rest
        }), {
            elementType: 'div'
        }),
        inputX: _reactutilities.slot.always(inputX, {
            defaultProps: {
                id: (0, _reactutilities.useId)('sliderX-'),
                type: 'range',
                ...activeAxis && {
                    tabIndex: activeAxis === 'x' ? 0 : -1
                }
            },
            elementType: 'input'
        }),
        inputY: _reactutilities.slot.always(inputY, {
            defaultProps: {
                id: (0, _reactutilities.useId)('sliderY-'),
                type: 'range',
                tabIndex: activeAxis && activeAxis === 'y' ? 0 : -1
            },
            elementType: 'input'
        }),
        thumb: _reactutilities.slot.always(thumb, {
            elementType: 'div'
        })
    };
    state.root.ref = (0, _reactutilities.useMergedRefs)(state.root.ref, rootRef);
    state.thumb.ref = (0, _reactutilities.useMergedRefs)(state.thumb.ref, focusWithinRef);
    state.inputX.ref = (0, _reactutilities.useMergedRefs)(state.inputX.ref, xRef);
    state.inputY.ref = (0, _reactutilities.useMergedRefs)(state.inputY.ref, yRef);
    state.root.style = {
        ...state.root.style,
        ...rootVariables
    };
    state.root.onPointerDown = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.root.onPointerDown, handleRootOnPointerDown));
    state.root.onKeyDown = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.root.onKeyDown, handleRootOnKeyDown));
    state.inputX.onChange = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.inputX.onChange, handleInputOnChange));
    state.inputY.onChange = (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(state.inputY.onChange, handleInputOnChange));
    state.inputX.value = saturation;
    state.inputY.value = value;
    return state;
};
