'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    alphaSliderCSSVars: function() {
        return alphaSliderCSSVars;
    },
    alphaSliderClassNames: function() {
        return alphaSliderClassNames;
    },
    useAlphaSliderStyles_unstable: function() {
        return useAlphaSliderStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _useColorSliderStylesstyles = require("../ColorSlider/useColorSliderStyles.styles");
const TRANSPARENT_IMAGE_URL = 'https://fabricweb.azureedge.net/fabric-website/assets/images/transparent-pattern.png';
const alphaSliderClassNames = {
    root: 'fui-AlphaSlider',
    rail: 'fui-AlphaSlider__rail',
    thumb: 'fui-AlphaSlider__thumb',
    input: 'fui-AlphaSlider__input'
};
const alphaSliderCSSVars = {
    sliderDirectionVar: `--fui-AlphaSlider--direction`,
    sliderProgressVar: `--fui-AlphaSlider--progress`,
    thumbColorVar: `--fui-AlphaSlider__thumb--color`,
    railColorVar: `--fui-AlphaSlider__rail--color`
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    rail: {
        border: `1px solid ${_reacttheme.tokens.colorNeutralStroke1}`,
        backgroundImage: `linear-gradient(var(${alphaSliderCSSVars.sliderDirectionVar}), transparent, var(${alphaSliderCSSVars.railColorVar})), url(${TRANSPARENT_IMAGE_URL})`
    }
});
/**
 * Styles for the thumb slot
 */ const useThumbStyles = (0, _react.makeStyles)({
    thumb: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        '::before': {
            backgroundColor: `var(${alphaSliderCSSVars.thumbColorVar})`
        }
    },
    horizontal: {
        transform: 'translateX(-50%)',
        left: `var(${alphaSliderCSSVars.sliderProgressVar})`
    },
    vertical: {
        transform: 'translateY(50%)',
        bottom: `var(${alphaSliderCSSVars.sliderProgressVar})`
    }
});
const useAlphaSliderStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const thumbStyles = useThumbStyles();
    state.root.className = (0, _react.mergeClasses)(alphaSliderClassNames.root, state.root.className);
    state.input.className = (0, _react.mergeClasses)(alphaSliderClassNames.input, state.input.className);
    state.rail.className = (0, _react.mergeClasses)(alphaSliderClassNames.rail, styles.rail, state.rail.className);
    state.thumb.className = (0, _react.mergeClasses)(alphaSliderClassNames.thumb, thumbStyles.thumb, state.vertical ? thumbStyles.vertical : thumbStyles.horizontal, state.thumb.className);
    state.thumb.className = (0, _react.mergeClasses)(alphaSliderClassNames.thumb, thumbStyles.thumb, state.vertical ? thumbStyles.vertical : thumbStyles.horizontal, state.thumb.className);
    (0, _useColorSliderStylesstyles.useColorSliderStyles_unstable)(state);
    return state;
};
