'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useAlphaSliderState_unstable", {
    enumerable: true,
    get: function() {
        return useAlphaSliderState_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _tinycolor = require("@ctrl/tinycolor");
const _reactutilities = require("@fluentui/react-utilities");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _useAlphaSliderStylesstyles = require("./useAlphaSliderStyles.styles");
const _colorPicker = require("../../contexts/colorPicker");
const _constants = require("../../utils/constants");
const _getPercent = require("../../utils/getPercent");
const _alphaSliderUtils = require("./alphaSliderUtils");
const _createHsvColor = require("../../utils/createHsvColor");
const useAlphaSliderState_unstable = (state, props)=>{
    'use no memo';
    var _props_defaultColor;
    const { dir } = (0, _reactsharedcontexts.useFluent_unstable)();
    const onChangeFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.requestChange);
    const colorFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.color);
    const { color, onChange = onChangeFromContext, transparency = false, vertical = false } = props;
    const hsvColor = color || colorFromContext;
    const hslColor = (0, _tinycolor.tinycolor)(hsvColor).toHsl();
    const [currentValue, setCurrentValue] = (0, _reactutilities.useControllableState)({
        defaultState: (0, _alphaSliderUtils.calculateTransparencyValue)(transparency, (_props_defaultColor = props.defaultColor) === null || _props_defaultColor === void 0 ? void 0 : _props_defaultColor.a),
        state: (0, _alphaSliderUtils.calculateTransparencyValue)(transparency, hsvColor === null || hsvColor === void 0 ? void 0 : hsvColor.a),
        initialState: (0, _alphaSliderUtils.adjustToTransparency)(100, transparency)
    });
    const clampedValue = (0, _reactutilities.clamp)(currentValue, _constants.MIN, _constants.MAX);
    const valuePercent = (0, _getPercent.getPercent)(clampedValue, _constants.MIN, _constants.MAX);
    const inputOnChange = state.input.onChange;
    const _onChange = (0, _reactutilities.useEventCallback)((event)=>{
        const newValue = (0, _alphaSliderUtils.adjustToTransparency)(Number(event.target.value), transparency);
        const newColor = (0, _createHsvColor.createHsvColor)({
            ...hsvColor,
            a: newValue / 100
        });
        setCurrentValue(newValue);
        inputOnChange === null || inputOnChange === void 0 ? void 0 : inputOnChange(event);
        onChange === null || onChange === void 0 ? void 0 : onChange(event, {
            type: 'change',
            event,
            color: newColor
        });
    });
    const sliderDirection = (0, _alphaSliderUtils.getSliderDirection)(dir, vertical, transparency);
    const rootVariables = {
        [_useAlphaSliderStylesstyles.alphaSliderCSSVars.sliderDirectionVar]: sliderDirection,
        [_useAlphaSliderStylesstyles.alphaSliderCSSVars.sliderProgressVar]: `${valuePercent}%`,
        [_useAlphaSliderStylesstyles.alphaSliderCSSVars.thumbColorVar]: `hsla(${hslColor.h} ${hslColor.s * 100}%, ${hslColor.l * 100}%, ${hslColor.a})`,
        [_useAlphaSliderStylesstyles.alphaSliderCSSVars.railColorVar]: `hsl(${hslColor.h} ${hslColor.s * 100}%, ${hslColor.l * 100}%)`
    };
    // Root props
    state.root.style = {
        ...rootVariables,
        ...state.root.style
    };
    // Input Props
    state.input.value = clampedValue;
    state.input.onChange = _onChange;
    return state;
};
