'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useAlphaSlider_unstable", {
    enumerable: true,
    get: function() {
        return useAlphaSlider_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _useAlphaSliderState = require("./useAlphaSliderState");
const _colorPicker = require("../../contexts/colorPicker");
const useAlphaSlider_unstable = (props, ref)=>{
    const shapeFromContext = (0, _colorPicker.useColorPickerContextValue_unstable)((ctx)=>ctx.shape);
    const nativeProps = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'input',
        excludedPropNames: [
            'onChange',
            'color'
        ]
    });
    const { shape = shapeFromContext, vertical, root, input, rail, thumb } = props;
    const state = {
        shape,
        vertical,
        components: {
            input: 'input',
            rail: 'div',
            root: 'div',
            thumb: 'div'
        },
        root: _reactutilities.slot.always(root, {
            defaultProps: nativeProps.root,
            elementType: 'div'
        }),
        input: _reactutilities.slot.always(input, {
            defaultProps: {
                id: (0, _reactutilities.useId)('slider-', props.id),
                ref,
                ...nativeProps.primary,
                type: 'range'
            },
            elementType: 'input'
        }),
        rail: _reactutilities.slot.always(rail, {
            elementType: 'div'
        }),
        thumb: _reactutilities.slot.always(thumb, {
            elementType: 'div'
        })
    };
    (0, _useAlphaSliderState.useAlphaSliderState_unstable)(state, props);
    return state;
};
