import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * AlphaSlider component
 */
export declare const AlphaSlider: ForwardRefComponent<AlphaSliderProps>;

export declare const alphaSliderClassNames: SlotClassNames<AlphaSliderSlots>;

/**
 * AlphaSlider Props
 */
export declare type AlphaSliderProps = Omit<ColorSliderProps, 'channel'> & {
    /**
     * The `transparency` property determines how the alpha channel is interpreted.
     * - When `false`, the alpha channel represents the opacity of the color.
     * - When `true`, the alpha channel represents the transparency of the color.
     * For example, a 30% transparent color has 70% opacity.
     *
     * @defaultvalue false
     */
    transparency?: boolean;
};

export declare type AlphaSliderSlots = ColorSliderSlots;

/**
 * State used in rendering AlphaSlider
 */
export declare type AlphaSliderState = ComponentState<AlphaSliderSlots> & Pick<AlphaSliderProps, 'vertical'> & Omit<ColorSliderState, keyof ColorSliderSlots | 'components'>;

/**
 * ColorArea component
 */
export declare const ColorArea: ForwardRefComponent<ColorAreaProps>;

export declare const colorAreaClassNames: SlotClassNames<ColorAreaSlots>;

declare type ColorAreaOnColorChangeData = EventData<'change', React_2.SyntheticEvent | PointerEvent> & {
    color: HsvColor;
};

/**
 * ColorArea Props
 */
export declare type ColorAreaProps = Omit<ComponentProps<Partial<ColorAreaSlots>>, 'color' | 'onChange'> & Pick<ColorPickerProps, 'shape'> & {
    /**
     * The current color of the ColorArea.
     */
    color?: HsvColor;
    /**
     * The starting value for an uncontrolled ColorArea.
     */
    defaultColor?: HsvColor;
    /**
     * Triggers a callback when the value has been changed. This will be called on every individual step.
     */
    onChange?: EventHandler<ColorAreaOnColorChangeData>;
};

export declare type ColorAreaSlots = {
    root: NonNullable<Slot<'div'>>;
    thumb?: NonNullable<Slot<'div'>>;
    inputX?: NonNullable<Slot<'input'>>;
    inputY?: NonNullable<Slot<'input'>>;
};

/**
 * State used in rendering ColorArea
 */
export declare type ColorAreaState = ComponentState<Required<ColorAreaSlots>> & Pick<ColorAreaProps, 'color' | 'shape'>;

declare type ColorChannel = 'hue' | 'saturation' | 'value';

/**
 * ColorPicker component
 */
export declare const ColorPicker: ForwardRefComponent<ColorPickerProps>;

export declare const colorPickerClassNames: SlotClassNames<ColorPickerSlots>;

/**
 * The context through which individual color controls communicate with the picker.
 */
declare type ColorPickerContextValue = Pick<ColorPickerProps, 'shape' | 'color'> & {
    /**
     * @internal
     * Callback used by Sliders to request a change on it's selected value
     * Should be used to get value of color channel
     */
    requestChange: (event: React_2.ChangeEvent<HTMLInputElement>, data: {
        color: HsvColor;
    }) => void;
};

declare type ColorPickerContextValues = {
    colorPicker: ColorPickerContextValue;
};

declare type ColorPickerOnChangeData = EventData<'change', React_2.ChangeEvent<HTMLInputElement>> & {
    color: HsvColor;
};

/**
 * ColorPicker Props
 */
export declare type ColorPickerProps = Omit<ComponentProps<Partial<ColorPickerSlots>>, 'color'> & {
    /**
     * Selected color.
     */
    color?: HsvColor;
    /**
     * Callback for when the user changes the color.
     */
    onColorChange?: EventHandler<ColorPickerOnChangeData>;
    /**
     * ColorPicker shape
     * @defaultvalue 'rounded'
     */
    shape?: 'rounded' | 'square';
};

export declare type ColorPickerSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering ColorPicker
 */
export declare type ColorPickerState = ComponentState<ColorPickerSlots> & ColorPickerContextValue;

/**
 * ColorSlider component
 */
export declare const ColorSlider: ForwardRefComponent<ColorSliderProps>;

export declare const colorSliderClassNames: SlotClassNames<ColorSliderSlots>;

/**
 * ColorSlider Props
 */
export declare type ColorSliderProps = Omit<ComponentProps<Partial<ColorSliderSlots>, 'input'>, 'defaultValue' | 'onChange' | 'value' | 'color'> & Pick<ColorPickerProps, 'shape'> & {
    /**
     * Color channel of the Slider.
     * @default `hue`
     */
    channel?: ColorChannel;
    /**
     * Triggers a callback when the value has been changed. This will be called on every individual step.
     */
    onChange?: EventHandler<SliderOnChangeData>;
    /**
     * Render the Slider in a vertical orientation, smallest value on the bottom.
     * @default `false`
     */
    vertical?: boolean;
    /**
     * Color of the ColorPicker
     */
    color?: HsvColor;
    /**
     * The starting color for an uncontrolled ColorSlider.
     */
    defaultColor?: HsvColor;
};

export declare type ColorSliderSlots = {
    root: NonNullable<Slot<'div'>>;
    rail: NonNullable<Slot<'div'>>;
    thumb: NonNullable<Slot<'div'>>;
    input: NonNullable<Slot<'input'>>;
};

/**
 * State used in rendering ColorSlider
 */
export declare type ColorSliderState = ComponentState<ColorSliderSlots> & Pick<ColorSliderProps, 'vertical' | 'shape' | 'channel'>;

declare type HsvColor = {
    h: number;
    s: number;
    v: number;
    a?: number;
};

/**
 * Render the final JSX of AlphaSlider
 */
export declare const renderAlphaSlider_unstable: (state: AlphaSliderState) => JSXElement;

/**
 * Render the final JSX of ColorArea
 */
export declare const renderColorArea_unstable: (state: ColorAreaState) => JSXElement;

/**
 * Render the final JSX of ColorPicker
 */
export declare const renderColorPicker_unstable: (state: ColorPickerState, contextValues: ColorPickerContextValues) => JSXElement;

/**
 * Render the final JSX of ColorSlider
 */
export declare const renderColorSlider_unstable: (state: ColorSliderState) => JSXElement;

declare type SliderOnChangeData = EventData<'change', React_2.ChangeEvent<HTMLInputElement>> & {
    color: HsvColor;
};

/**
 * Create the state required to render AlphaSlider.
 *
 * The returned state can be modified with hooks such as useAlphaSliderStyles_unstable,
 * before being passed to renderAlphaSlider_unstable.
 *
 * @param props - props from this instance of AlphaSlider
 * @param ref - reference to root HTMLInputElement of AlphaSlider
 */
export declare const useAlphaSlider_unstable: (props: AlphaSliderProps, ref: React_2.Ref<HTMLInputElement>) => AlphaSliderState;

/**
 * Apply styling to the AlphaSlider slots based on the state
 */
export declare const useAlphaSliderStyles_unstable: (state: AlphaSliderState) => AlphaSliderState;

/**
 * Create the state required to render ColorArea.
 *
 * The returned state can be modified with hooks such as useColorAreaStyles_unstable,
 * before being passed to renderColorArea_unstable.
 *
 * @param props - props from this instance of ColorArea
 * @param ref - reference to root HTMLDivElement of ColorArea
 */
export declare const useColorArea_unstable: (props: ColorAreaProps, ref: React_2.Ref<HTMLDivElement>) => ColorAreaState;

/**
 * Apply styling to the ColorArea slots based on the state
 */
export declare const useColorAreaStyles_unstable: (state: ColorAreaState) => ColorAreaState;

/**
 * Create the state required to render ColorPicker.
 *
 * The returned state can be modified with hooks such as useColorPickerStyles_unstable,
 * before being passed to renderColorPicker_unstable.
 *
 * @param props - props from this instance of ColorPicker
 * @param ref - reference to root HTMLDivElement of ColorPicker
 */
export declare const useColorPicker_unstable: (props: ColorPickerProps, ref: React_2.Ref<HTMLDivElement>) => ColorPickerState;

/**
 * Apply styling to the ColorPicker slots based on the state
 */
export declare const useColorPickerStyles_unstable: (state: ColorPickerState) => ColorPickerState;

/**
 * Create the state required to render ColorSlider.
 *
 * The returned state can be modified with hooks such as useColorSliderStyles_unstable,
 * before being passed to renderColorSlider_unstable.
 *
 * @param props - props from this instance of ColorSlider
 * @param ref - reference to root HTMLInputElement of ColorSlider
 */
export declare const useColorSlider_unstable: (props: ColorSliderProps, ref: React_2.Ref<HTMLInputElement>) => ColorSliderState;

/**
 * Apply styling to the ColorSlider slots based on the state
 */
export declare const useColorSliderStyles_unstable: (state: ColorSliderState) => ColorSliderState;

export { }
