'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    checkboxClassNames: function() {
        return checkboxClassNames;
    },
    useCheckboxStyles_unstable: function() {
        return useCheckboxStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const checkboxClassNames = {
    root: 'fui-Checkbox',
    label: 'fui-Checkbox__label',
    input: 'fui-Checkbox__input',
    indicator: 'fui-Checkbox__indicator'
};
// CSS variables used internally in Checkbox's styles
const vars = {
    indicatorColor: '--fui-Checkbox__indicator--color',
    indicatorBorderColor: '--fui-Checkbox__indicator--borderColor',
    indicatorBackgroundColor: '--fui-Checkbox__indicator--backgroundColor'
};
// The indicator size is used by the indicator and label styles
const indicatorSizeMedium = '16px';
const indicatorSizeLarge = '20px';
const useRootBaseClassName = (0, _react.makeResetStyles)({
    position: 'relative',
    display: 'inline-flex',
    cursor: 'pointer',
    maxWidth: 'fit-content',
    verticalAlign: 'middle',
    color: _reacttheme.tokens.colorNeutralForeground3,
    ...(0, _reacttabster.createFocusOutlineStyle)({
        style: {},
        selector: 'focus-within'
    })
});
const useRootStyles = (0, _react.makeStyles)({
    unchecked: {
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground2,
            [vars.indicatorBorderColor]: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
        },
        ':active': {
            color: _reacttheme.tokens.colorNeutralForeground1,
            [vars.indicatorBorderColor]: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
        }
    },
    checked: {
        color: _reacttheme.tokens.colorNeutralForeground1,
        [vars.indicatorBackgroundColor]: _reacttheme.tokens.colorCompoundBrandBackground,
        [vars.indicatorColor]: _reacttheme.tokens.colorNeutralForegroundInverted,
        [vars.indicatorBorderColor]: _reacttheme.tokens.colorCompoundBrandBackground,
        ':hover': {
            [vars.indicatorBackgroundColor]: _reacttheme.tokens.colorCompoundBrandBackgroundHover,
            [vars.indicatorBorderColor]: _reacttheme.tokens.colorCompoundBrandBackgroundHover
        },
        ':active': {
            [vars.indicatorBackgroundColor]: _reacttheme.tokens.colorCompoundBrandBackgroundPressed,
            [vars.indicatorBorderColor]: _reacttheme.tokens.colorCompoundBrandBackgroundPressed
        }
    },
    mixed: {
        color: _reacttheme.tokens.colorNeutralForeground1,
        [vars.indicatorBorderColor]: _reacttheme.tokens.colorCompoundBrandStroke,
        [vars.indicatorColor]: _reacttheme.tokens.colorCompoundBrandForeground1,
        ':hover': {
            [vars.indicatorBorderColor]: _reacttheme.tokens.colorCompoundBrandStrokeHover,
            [vars.indicatorColor]: _reacttheme.tokens.colorCompoundBrandForeground1Hover
        },
        ':active': {
            [vars.indicatorBorderColor]: _reacttheme.tokens.colorCompoundBrandStrokePressed,
            [vars.indicatorColor]: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
        }
    },
    disabled: {
        cursor: 'default',
        color: _reacttheme.tokens.colorNeutralForegroundDisabled,
        [vars.indicatorBorderColor]: _reacttheme.tokens.colorNeutralStrokeDisabled,
        [vars.indicatorColor]: _reacttheme.tokens.colorNeutralForegroundDisabled,
        '@media (forced-colors: active)': {
            color: 'GrayText',
            [vars.indicatorColor]: 'GrayText'
        }
    }
});
const useInputBaseClassName = (0, _react.makeResetStyles)({
    boxSizing: 'border-box',
    cursor: 'inherit',
    height: '100%',
    margin: 0,
    opacity: 0,
    position: 'absolute',
    top: 0,
    // Calculate the width of the hidden input by taking into account the size of the indicator + the padding around it.
    // This is done so that clicking on that "empty space" still toggles the checkbox.
    width: `calc(${indicatorSizeMedium} + 2 * ${_reacttheme.tokens.spacingHorizontalS})`
});
const useInputStyles = (0, _react.makeStyles)({
    before: {
        right: 0
    },
    after: {
        left: 0
    },
    large: {
        width: `calc(${indicatorSizeLarge} + 2 * ${_reacttheme.tokens.spacingHorizontalS})`
    }
});
const useIndicatorBaseClassName = (0, _react.makeResetStyles)({
    alignSelf: 'flex-start',
    boxSizing: 'border-box',
    flexShrink: 0,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    overflow: 'hidden',
    color: `var(${vars.indicatorColor})`,
    backgroundColor: `var(${vars.indicatorBackgroundColor})`,
    borderColor: `var(${vars.indicatorBorderColor}, ${_reacttheme.tokens.colorNeutralStrokeAccessible})`,
    borderStyle: 'solid',
    borderWidth: _reacttheme.tokens.strokeWidthThin,
    borderRadius: _reacttheme.tokens.borderRadiusSmall,
    margin: _reacttheme.tokens.spacingVerticalS + ' ' + _reacttheme.tokens.spacingHorizontalS,
    fill: 'currentColor',
    pointerEvents: 'none',
    fontSize: '12px',
    height: indicatorSizeMedium,
    width: indicatorSizeMedium
});
const useIndicatorStyles = (0, _react.makeStyles)({
    large: {
        fontSize: '16px',
        height: indicatorSizeLarge,
        width: indicatorSizeLarge
    },
    circular: {
        borderRadius: _reacttheme.tokens.borderRadiusCircular
    }
});
// Can't use makeResetStyles here because Label is a component that may itself use makeResetStyles.
const useLabelStyles = (0, _react.makeStyles)({
    base: {
        alignSelf: 'center',
        color: 'inherit',
        cursor: 'inherit',
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalS}`
    },
    before: {
        paddingRight: _reacttheme.tokens.spacingHorizontalXS
    },
    after: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXS
    },
    // Use a (negative) margin to account for the difference between the indicator's height and the label's line height.
    // This prevents the label from expanding the height of the checkbox, but preserves line height if the label wraps.
    medium: {
        marginTop: `calc((${indicatorSizeMedium} - ${_reacttheme.tokens.lineHeightBase300}) / 2)`,
        marginBottom: `calc((${indicatorSizeMedium} - ${_reacttheme.tokens.lineHeightBase300}) / 2)`
    },
    large: {
        marginTop: `calc((${indicatorSizeLarge} - ${_reacttheme.tokens.lineHeightBase300}) / 2)`,
        marginBottom: `calc((${indicatorSizeLarge} - ${_reacttheme.tokens.lineHeightBase300}) / 2)`
    }
});
const useCheckboxStyles_unstable = (state)=>{
    'use no memo';
    const { checked, disabled, labelPosition, shape, size } = state;
    const rootBaseClassName = useRootBaseClassName();
    const rootStyles = useRootStyles();
    state.root.className = (0, _react.mergeClasses)(checkboxClassNames.root, rootBaseClassName, disabled ? rootStyles.disabled : checked === 'mixed' ? rootStyles.mixed : checked ? rootStyles.checked : rootStyles.unchecked, state.root.className);
    const inputBaseClassName = useInputBaseClassName();
    const inputStyles = useInputStyles();
    state.input.className = (0, _react.mergeClasses)(checkboxClassNames.input, inputBaseClassName, size === 'large' && inputStyles.large, inputStyles[labelPosition], state.input.className);
    const indicatorBaseClassName = useIndicatorBaseClassName();
    const indicatorStyles = useIndicatorStyles();
    if (state.indicator) {
        state.indicator.className = (0, _react.mergeClasses)(checkboxClassNames.indicator, indicatorBaseClassName, size === 'large' && indicatorStyles.large, shape === 'circular' && indicatorStyles.circular, state.indicator.className);
    }
    const labelStyles = useLabelStyles();
    if (state.label) {
        state.label.className = (0, _react.mergeClasses)(checkboxClassNames.label, labelStyles.base, labelStyles[size], labelStyles[labelPosition], state.label.className);
    }
    return state;
};
