'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    checkboxClassNames: function() {
        return checkboxClassNames;
    },
    useCheckboxStyles_unstable: function() {
        return useCheckboxStyles_unstable;
    }
});
const _react = require("@griffel/react");
const checkboxClassNames = {
    root: 'fui-Checkbox',
    label: 'fui-Checkbox__label',
    input: 'fui-Checkbox__input',
    indicator: 'fui-Checkbox__indicator'
};
// CSS variables used internally in Checkbox's styles
const vars = {
    indicatorColor: '--fui-Checkbox__indicator--color',
    indicatorBorderColor: '--fui-Checkbox__indicator--borderColor',
    indicatorBackgroundColor: '--fui-Checkbox__indicator--backgroundColor'
};
// The indicator size is used by the indicator and label styles
const indicatorSizeMedium = '16px';
const indicatorSizeLarge = '20px';
const useRootBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r1nzur1d", "r128arqq", {
    r: [
        ".r1nzur1d{position:relative;display:inline-flex;cursor:pointer;max-width:fit-content;vertical-align:middle;color:var(--colorNeutralForeground3);}",
        ".r1nzur1d:focus{outline-style:none;}",
        ".r1nzur1d:focus-visible{outline-style:none;}",
        ".r1nzur1d[data-fui-focus-within]:focus-within{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}",
        ".r1nzur1d[data-fui-focus-within]:focus-within::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}",
        ".r128arqq{position:relative;display:inline-flex;cursor:pointer;max-width:fit-content;vertical-align:middle;color:var(--colorNeutralForeground3);}",
        ".r128arqq:focus{outline-style:none;}",
        ".r128arqq:focus-visible{outline-style:none;}",
        ".r128arqq[data-fui-focus-within]:focus-within{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}",
        ".r128arqq[data-fui-focus-within]:focus-within::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}"
    ],
    s: [
        "@media (forced-colors: active){.r1nzur1d[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}",
        "@media (forced-colors: active){.r128arqq[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}"
    ]
});
const useRootStyles = /*#__PURE__*/ (0, _react.__styles)({
    unchecked: {
        Bi91k9c: "f3p8bqa",
        pv5h1i: "fium13f",
        lj723h: "f1r2dosr",
        Hnthvo: "f1729es6"
    },
    checked: {
        sj55zd: "f19n0e5",
        wkncrt: "f35ds98",
        zxk7z7: "f12mnkne",
        Hmsnfy: "fei9a8h",
        e6czan: "fix56y3",
        pv5h1i: "f1bcv2js",
        qbydtz: "f7dr4go",
        Hnthvo: "f1r5cpua"
    },
    mixed: {
        sj55zd: "f19n0e5",
        Hmsnfy: "f1l27tf0",
        zxk7z7: "fcilktj",
        pv5h1i: "f1lphd54",
        Bunfa6h: "f1obkvq7",
        Hnthvo: "f2gmbuh",
        B15ykmv: "f1oy4fa1"
    },
    disabled: {
        Bceei9c: "f158kwzp",
        sj55zd: "f1s2aq7o",
        Hmsnfy: "f1w7mfl5",
        zxk7z7: "fcoafq6",
        Bbusuzp: "f1dcs8yz",
        mrqfp9: "fxb3eh3"
    }
}, {
    h: [
        ".f3p8bqa:hover{color:var(--colorNeutralForeground2);}",
        ".fium13f:hover{--fui-Checkbox__indicator--borderColor:var(--colorNeutralStrokeAccessibleHover);}",
        ".fix56y3:hover{--fui-Checkbox__indicator--backgroundColor:var(--colorCompoundBrandBackgroundHover);}",
        ".f1bcv2js:hover{--fui-Checkbox__indicator--borderColor:var(--colorCompoundBrandBackgroundHover);}",
        ".f1lphd54:hover{--fui-Checkbox__indicator--borderColor:var(--colorCompoundBrandStrokeHover);}",
        ".f1obkvq7:hover{--fui-Checkbox__indicator--color:var(--colorCompoundBrandForeground1Hover);}"
    ],
    a: [
        ".f1r2dosr:active{color:var(--colorNeutralForeground1);}",
        ".f1729es6:active{--fui-Checkbox__indicator--borderColor:var(--colorNeutralStrokeAccessiblePressed);}",
        ".f7dr4go:active{--fui-Checkbox__indicator--backgroundColor:var(--colorCompoundBrandBackgroundPressed);}",
        ".f1r5cpua:active{--fui-Checkbox__indicator--borderColor:var(--colorCompoundBrandBackgroundPressed);}",
        ".f2gmbuh:active{--fui-Checkbox__indicator--borderColor:var(--colorCompoundBrandStrokePressed);}",
        ".f1oy4fa1:active{--fui-Checkbox__indicator--color:var(--colorCompoundBrandForeground1Pressed);}"
    ],
    d: [
        ".f19n0e5{color:var(--colorNeutralForeground1);}",
        ".f35ds98{--fui-Checkbox__indicator--backgroundColor:var(--colorCompoundBrandBackground);}",
        ".f12mnkne{--fui-Checkbox__indicator--color:var(--colorNeutralForegroundInverted);}",
        ".fei9a8h{--fui-Checkbox__indicator--borderColor:var(--colorCompoundBrandBackground);}",
        ".f1l27tf0{--fui-Checkbox__indicator--borderColor:var(--colorCompoundBrandStroke);}",
        ".fcilktj{--fui-Checkbox__indicator--color:var(--colorCompoundBrandForeground1);}",
        ".f158kwzp{cursor:default;}",
        ".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}",
        ".f1w7mfl5{--fui-Checkbox__indicator--borderColor:var(--colorNeutralStrokeDisabled);}",
        ".fcoafq6{--fui-Checkbox__indicator--color:var(--colorNeutralForegroundDisabled);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1dcs8yz{color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fxb3eh3{--fui-Checkbox__indicator--color:GrayText;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
const useInputBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("ruo9svu", null, [
    ".ruo9svu{box-sizing:border-box;cursor:inherit;height:100%;margin:0;opacity:0;position:absolute;top:0;width:calc(16px + 2 * var(--spacingHorizontalS));}"
]);
const useInputStyles = /*#__PURE__*/ (0, _react.__styles)({
    before: {
        j35jbq: [
            "f1e31b4d",
            "f1vgc2s3"
        ]
    },
    after: {
        oyh7mz: [
            "f1vgc2s3",
            "f1e31b4d"
        ]
    },
    large: {
        a9b677: "f1mq5jt6"
    }
}, {
    d: [
        ".f1e31b4d{right:0;}",
        ".f1vgc2s3{left:0;}",
        ".f1mq5jt6{width:calc(20px + 2 * var(--spacingHorizontalS));}"
    ]
});
const useIndicatorBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("rl7ci6d", null, [
    ".rl7ci6d{align-self:flex-start;box-sizing:border-box;flex-shrink:0;display:flex;align-items:center;justify-content:center;overflow:hidden;color:var(--fui-Checkbox__indicator--color);background-color:var(--fui-Checkbox__indicator--backgroundColor);border-color:var(--fui-Checkbox__indicator--borderColor, var(--colorNeutralStrokeAccessible));border-style:solid;border-width:var(--strokeWidthThin);border-radius:var(--borderRadiusSmall);margin:var(--spacingVerticalS) var(--spacingHorizontalS);fill:currentColor;pointer-events:none;font-size:12px;height:16px;width:16px;}"
]);
const useIndicatorStyles = /*#__PURE__*/ (0, _react.__styles)({
    large: {
        Be2twd7: "f4ybsrx",
        Bqenvij: "fjamq6b",
        a9b677: "f64fuq3"
    },
    circular: {
        Beyfa6y: 0,
        Bbmb7ep: 0,
        Btl43ni: 0,
        B7oj6ja: 0,
        Dimara: "f44lkw9"
    }
}, {
    d: [
        ".f4ybsrx{font-size:16px;}",
        ".fjamq6b{height:20px;}",
        ".f64fuq3{width:20px;}",
        [
            ".f44lkw9{border-radius:var(--borderRadiusCircular);}",
            {
                p: -1
            }
        ]
    ]
});
// Can't use makeResetStyles here because Label is a component that may itself use makeResetStyles.
const useLabelStyles = /*#__PURE__*/ (0, _react.__styles)({
    base: {
        qb2dma: "f7nlbp4",
        sj55zd: "f1ym3bx4",
        Bceei9c: "fpo1scq",
        Byoj8tv: 0,
        uwmqm3: 0,
        z189sj: 0,
        z8tnut: 0,
        B0ocmuz: "f1f5q0n8"
    },
    before: {
        z189sj: [
            "f7x41pl",
            "fruq291"
        ]
    },
    after: {
        uwmqm3: [
            "fruq291",
            "f7x41pl"
        ]
    },
    medium: {
        B6of3ja: "fjzwpt6",
        jrapky: "fh6j2fo"
    },
    large: {
        B6of3ja: "f1xlvstr",
        jrapky: "f49ad5g"
    }
}, {
    d: [
        ".f7nlbp4{align-self:center;}",
        ".f1ym3bx4{color:inherit;}",
        ".fpo1scq{cursor:inherit;}",
        [
            ".f1f5q0n8{padding:var(--spacingVerticalS) var(--spacingHorizontalS);}",
            {
                p: -1
            }
        ],
        ".f7x41pl{padding-right:var(--spacingHorizontalXS);}",
        ".fruq291{padding-left:var(--spacingHorizontalXS);}",
        ".fjzwpt6{margin-top:calc((16px - var(--lineHeightBase300)) / 2);}",
        ".fh6j2fo{margin-bottom:calc((16px - var(--lineHeightBase300)) / 2);}",
        ".f1xlvstr{margin-top:calc((20px - var(--lineHeightBase300)) / 2);}",
        ".f49ad5g{margin-bottom:calc((20px - var(--lineHeightBase300)) / 2);}"
    ]
});
const useCheckboxStyles_unstable = (state)=>{
    'use no memo';
    const { checked, disabled, labelPosition, shape, size } = state;
    const rootBaseClassName = useRootBaseClassName();
    const rootStyles = useRootStyles();
    state.root.className = (0, _react.mergeClasses)(checkboxClassNames.root, rootBaseClassName, disabled ? rootStyles.disabled : checked === 'mixed' ? rootStyles.mixed : checked ? rootStyles.checked : rootStyles.unchecked, state.root.className);
    const inputBaseClassName = useInputBaseClassName();
    const inputStyles = useInputStyles();
    state.input.className = (0, _react.mergeClasses)(checkboxClassNames.input, inputBaseClassName, size === 'large' && inputStyles.large, inputStyles[labelPosition], state.input.className);
    const indicatorBaseClassName = useIndicatorBaseClassName();
    const indicatorStyles = useIndicatorStyles();
    if (state.indicator) {
        state.indicator.className = (0, _react.mergeClasses)(checkboxClassNames.indicator, indicatorBaseClassName, size === 'large' && indicatorStyles.large, shape === 'circular' && indicatorStyles.circular, state.indicator.className);
    }
    const labelStyles = useLabelStyles();
    if (state.label) {
        state.label.className = (0, _react.mergeClasses)(checkboxClassNames.label, labelStyles.base, labelStyles[size], labelStyles[labelPosition], state.label.className);
    }
    return state;
};
