# @fluentui/react-checkbox

**Checkbox component for [Fluent UI React](https://react.fluentui.dev/)**

Checkboxes give people a way to select one or more items from a group, or switch between
two mutually exclusive options (checked or unchecked).

### Usage

Import Checkbox:

```js
import { Checkbox } from '@fluentui/react-components';
```

#### Examples

```jsx
<Checkbox label="Default checkbox" />
<Checkbox disabled label="Disabled" />
<Checkbox shape="circular" label="Circular" />
```

See [Fluent UI Storybook](https://react.fluentui.dev/) for more detailed usage examples.

Alternatively, run Storybook locally with:

1. `yarn start`
2. Select `react-checkbox` from the list.

### Specification

See [Spec.md](./Spec.md).

### Migration Guide

If you're upgrading to Fluent UI v9 see [MIGRATION.md](./MIGRATION.md) for guidance on updating to the latest Checkbox implementation.
