'use client';
import * as React from 'react';
import { useCarouselNavButton_unstable } from './useCarouselNavButton';
import { renderCarouselNavButton_unstable } from './renderCarouselNavButton';
import { useCarouselNavButtonStyles_unstable } from './useCarouselNavButtonStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * The child element of CarouselNav, a singular button that will set the carousels active value on click.
 */ export const CarouselNavButton = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useCarouselNavButton_unstable(props, ref);
    useCarouselNavButtonStyles_unstable(state);
    useCustomStyleHook_unstable('useCarouselNavButtonStyles_unstable')(state);
    return renderCarouselNavButton_unstable(state);
});
CarouselNavButton.displayName = 'CarouselNavButton';
