'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { useButtonStyles_unstable } from '@fluentui/react-button';
import { tokens } from '@fluentui/react-theme';
export const carouselButtonClassNames = {
  root: 'fui-CarouselButton',
  icon: 'fui-CarouselButton__icon'
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    B6of3ja: "fgr6219",
    jrapky: "f10jk5vf",
    sj55zd: "fkfq4zb",
    De3pzq: "fkfdr9r",
    Bkecrkj: "fc5wo7j",
    eoavqd: "f8491dx"
  }
}, {
  d: [".fgr6219{margin-top:auto;}", ".f10jk5vf{margin-bottom:auto;}", ".fkfq4zb{color:var(--colorNeutralForeground2);}", ".fkfdr9r{background-color:var(--colorNeutralBackgroundAlpha);}", ".fc5wo7j{pointer-events:all;}"],
  h: [".f8491dx:hover{cursor:pointer;}"]
});
/**
 * Apply styling to the CarouselButton slots based on the state
 */
export const useCarouselButtonStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  state = {
    ...state,
    ...useButtonStyles_unstable(state)
  };
  state.root.className = mergeClasses(carouselButtonClassNames.root, styles.root, state.root.className);
  if (state.icon) {
    state.icon.className = mergeClasses(carouselButtonClassNames.icon, state.icon.className);
  }
  return state;
};