'use client';
import { makeStyles, mergeClasses, shorthands } from '@griffel/react';
import { useToggleButtonStyles_unstable } from '@fluentui/react-button';
import { tokens } from '@fluentui/react-theme';
export const carouselAutoplayButtonClassNames = {
    root: 'fui-CarouselAutoplayButton',
    icon: 'fui-CarouselAutoplayButton__icon'
};
/**
 * Styles for the root slot
 */ const useStyles = makeStyles({
    root: {
        pointerEvents: 'all',
        marginTop: 'auto',
        marginBottom: 'auto',
        ...shorthands.borderColor(tokens.colorTransparentStroke),
        color: tokens.colorNeutralForeground2,
        backgroundColor: tokens.colorNeutralBackgroundAlpha,
        ':hover': {
            cursor: 'pointer'
        }
    }
});
/**
 * Apply styling to the CarouselAutoplayButton slots based on the state
 */ export const useCarouselAutoplayButtonStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    useToggleButtonStyles_unstable(state);
    state.root.className = mergeClasses(carouselAutoplayButtonClassNames.root, styles.root, state.root.className);
    if (state.icon) {
        state.icon.className = mergeClasses(carouselAutoplayButtonClassNames.icon, state.icon.className);
    }
    return state;
};
