'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    carouselNavImageButtonClassNames: function() {
        return carouselNavImageButtonClassNames;
    },
    useCarouselNavImageButtonStyles_unstable: function() {
        return useCarouselNavImageButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const carouselNavImageButtonClassNames = {
    root: 'fui-CarouselNavImageButton',
    image: 'fui-CarouselNavImageButton__image'
};
const imageButtonSize = 40;
const selectedImageButtonSize = 48;
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        boxSizing: 'content-box',
        padding: '0px',
        margin: `0 ${_reacttheme.tokens.spacingHorizontalXS}`,
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke),
        borderRadius: _reacttheme.tokens.borderRadiusSmall,
        width: imageButtonSize + 'px',
        height: imageButtonSize + 'px',
        overflow: 'hidden',
        ':hover': {
            cursor: 'pointer'
        }
    },
    image: {
        width: imageButtonSize + 'px',
        height: imageButtonSize + 'px',
        borderRadius: _reacttheme.tokens.borderRadiusSmall
    },
    selected: {
        width: selectedImageButtonSize + 'px',
        height: selectedImageButtonSize + 'px'
    }
});
const useCarouselNavImageButtonStyles_unstable = (state)=>{
    'use no memo';
    const { selected } = state;
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(carouselNavImageButtonClassNames.root, styles.root, selected && styles.selected, state.root.className);
    if (state.image) {
        var _state_image;
        state.image.className = (0, _react.mergeClasses)(carouselNavImageButtonClassNames.image, styles.image, selected && styles.selected, (_state_image = state.image) === null || _state_image === void 0 ? void 0 : _state_image.className);
    }
    return state;
};
