'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    carouselNavContainerClassNames: function() {
        return carouselNavContainerClassNames;
    },
    useCarouselNavContainerStyles_unstable: function() {
        return useCarouselNavContainerStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const carouselNavContainerClassNames = {
    root: 'fui-CarouselNavContainer',
    next: 'fui-CarouselNavContainer__next',
    prev: 'fui-CarouselNavContainer__prev',
    autoplay: 'fui-CarouselNavContainer__autoplay',
    /* Tooltip classNames are listed for type compatibility only (cannot assign root className to portal)
   * Use 'content' slot to style Tooltip content instead
   */ nextTooltip: 'fui-CarouselNavContainer__nextTooltip',
    prevTooltip: 'fui-CarouselNavContainer__prevTooltip',
    autoplayTooltip: 'fui-CarouselNavContainer__autoplayTooltip'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'center',
        width: '100%',
        pointerEvents: 'none'
    },
    next: {},
    prev: {},
    autoplay: {},
    inline: {
        marginTop: _reacttheme.tokens.spacingVerticalM
    },
    overlay: {
        position: 'absolute',
        bottom: _reacttheme.tokens.spacingVerticalM,
        boxSizing: 'border-box'
    },
    overlayWide: {
        bottom: _reacttheme.tokens.spacingVerticalM
    },
    nextWide: {
        marginLeft: 'auto'
    },
    prevWide: {
        marginRight: 'auto'
    },
    nextOverlayWide: {
        marginRight: _reacttheme.tokens.spacingHorizontalM
    },
    prevOverlayWide: {
        marginLeft: _reacttheme.tokens.spacingHorizontalM
    },
    autoplayOverlayWide: {
        marginLeft: _reacttheme.tokens.spacingHorizontalM
    },
    expanded: {
        width: '100%',
        height: '100%',
        alignItems: 'flex-end',
        justifyContent: 'center',
        bottom: 0,
        '> div': {
            position: 'relative',
            bottom: _reacttheme.tokens.spacingVerticalL,
            marginBottom: 0
        }
    },
    nextOverlayExpanded: {
        position: 'absolute',
        right: _reacttheme.tokens.spacingHorizontalM,
        top: '50%',
        transform: 'translateY(-50%)'
    },
    prevOverlayExpanded: {
        position: 'absolute',
        left: _reacttheme.tokens.spacingHorizontalM,
        top: '50%',
        transform: 'translateY(-50%)'
    },
    autoplayExpanded: {
        position: 'absolute',
        bottom: `-${_reacttheme.tokens.spacingHorizontalXS}`,
        left: _reacttheme.tokens.spacingHorizontalM,
        marginBottom: _reacttheme.tokens.spacingVerticalM
    }
});
const useCarouselNavContainerStyles_unstable = (state)=>{
    'use no memo';
    const { layout } = state;
    const isOverlay = layout === 'overlay' || layout === 'overlay-wide' || layout === 'overlay-expanded';
    const isWide = layout === 'inline-wide' || layout === 'overlay-wide';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(carouselNavContainerClassNames.root, styles.root, isOverlay ? styles.overlay : styles.inline, isOverlay && isWide && styles.overlayWide, layout === 'overlay-expanded' && styles.expanded, state.root.className);
    if (state.next) {
        state.next.className = (0, _react.mergeClasses)(carouselNavContainerClassNames.next, styles.next, isWide && styles.nextWide, isWide && isOverlay && styles.nextOverlayWide, layout === 'overlay-expanded' && styles.nextOverlayExpanded, state.next.className);
    }
    if (state.prev) {
        state.prev.className = (0, _react.mergeClasses)(carouselNavContainerClassNames.prev, styles.prev, isWide && styles.prevWide, !state.autoplay && isWide && isOverlay && styles.prevOverlayWide, layout === 'overlay-expanded' && styles.prevOverlayExpanded, state.prev.className);
    }
    if (state.autoplay) {
        state.autoplay.className = (0, _react.mergeClasses)(carouselNavContainerClassNames.autoplay, styles.autoplay, layout === 'overlay-expanded' && styles.autoplayExpanded, isWide && isOverlay && styles.autoplayOverlayWide, state.autoplay.className);
    }
    return state;
};
