'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    carouselNavButtonClassNames: function() {
        return carouselNavButtonClassNames;
    },
    useCarouselNavButtonStyles_unstable: function() {
        return useCarouselNavButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const carouselNavButtonClassNames = {
    root: 'fui-CarouselNavButton'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        cursor: 'pointer',
        pointerEvents: 'all',
        width: _reacttheme.tokens.spacingHorizontalS,
        height: _reacttheme.tokens.spacingVerticalS,
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalS}`,
        boxSizing: 'content-box',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        ..._react.shorthands.borderWidth(0),
        '::after': {
            content: '""',
            display: 'block',
            boxSizing: 'border-box',
            borderRadius: '50%',
            border: 'none',
            height: _reacttheme.tokens.spacingVerticalS,
            width: _reacttheme.tokens.spacingHorizontalS,
            backgroundColor: _reacttheme.tokens.colorNeutralForeground1,
            color: _reacttheme.tokens.colorNeutralForeground1,
            '@media (forced-colors: active)': {
                // Bypass OS high contrast with inverted blend mode (otherwise icon is invisible)
                forcedColorAdjust: 'none',
                backgroundColor: 'white',
                mixBlendMode: 'difference'
            }
        }
    },
    rootUnselected: {
        outline: `${_reacttheme.tokens.strokeWidthThin} solid transparent`,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            border: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            margin: `calc(-1 * ${_reacttheme.tokens.strokeWidthThick})`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        }),
        '::after': {
            opacity: 0.6
        },
        ':hover': {
            '::after': {
                opacity: 0.75
            }
        },
        ':active': {
            '::after': {
                opacity: 1
            }
        }
    },
    rootSelected: {
        width: _reacttheme.tokens.spacingHorizontalL,
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalXS}`,
        outline: `${_reacttheme.tokens.strokeWidthThin} solid transparent`,
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            border: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            margin: `calc(-1 * ${_reacttheme.tokens.strokeWidthThick})`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium
        }),
        '::after': {
            width: _reacttheme.tokens.spacingHorizontalL,
            borderRadius: '4px'
        },
        ':hover': {
            '::after': {
                opacity: 0.75
            }
        },
        ':active': {
            '::after': {
                opacity: 0.65
            }
        }
    },
    brand: {
        '::after': {
            backgroundColor: _reacttheme.tokens.colorCompoundBrandBackground,
            opacity: 1
        },
        ':hover': {
            '::after': {
                backgroundColor: _reacttheme.tokens.colorCompoundBrandBackgroundHover,
                opacity: 1
            }
        },
        ':active': {
            '::after': {
                backgroundColor: _reacttheme.tokens.colorCompoundBrandBackgroundPressed,
                opacity: 1
            }
        }
    },
    unselectedBrand: {
        '::after': {
            opacity: 0.6,
            backgroundColor: _reacttheme.tokens.colorNeutralForeground1
        },
        ':hover': {
            '::after': {
                opacity: 0.75
            }
        },
        ':active': {
            '::after': {
                opacity: 1
            }
        }
    }
});
const useCarouselNavButtonStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    const { selected, appearance } = state;
    state.root.className = (0, _react.mergeClasses)(carouselNavButtonClassNames.root, styles.root, selected ? styles.rootSelected : styles.rootUnselected, appearance === 'brand' && styles.brand, !selected && appearance === 'brand' && styles.unselectedBrand, state.root.className);
    return state;
};
