'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    carouselNavClassNames: function() {
        return carouselNavClassNames;
    },
    useCarouselNavStyles_unstable: function() {
        return useCarouselNavStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const carouselNavClassNames = {
    root: 'fui-CarouselNav'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'center',
        pointerEvents: 'all',
        ...(0, _reacttabster.createCustomFocusIndicatorStyle)({
            outline: `${_reacttheme.tokens.strokeWidthThick} solid ${_reacttheme.tokens.colorStrokeFocus2}`,
            borderRadius: _reacttheme.tokens.borderRadiusMedium,
            ..._react.shorthands.borderColor('transparent')
        }),
        borderRadius: _reacttheme.tokens.borderRadiusXLarge,
        margin: `auto ${_reacttheme.tokens.spacingHorizontalS}`,
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundAlpha
    }
});
const useCarouselNavStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(carouselNavClassNames.root, styles.root, state.root.className);
    return state;
};
