'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCarouselCard_unstable", {
    enumerable: true,
    get: function() {
        return useCarouselCard_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reacttabster = require("@fluentui/react-tabster");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _CarouselContext = require("../CarouselContext");
const _useEmblaCarousel = require("../useEmblaCarousel");
const _useCarouselCardStylesstyles = require("./useCarouselCardStyles.styles");
const _CarouselSliderContext = require("../CarouselSlider/CarouselSliderContext");
const useCarouselCard_unstable = (props, ref)=>{
    const { autoSize } = props;
    const elementRef = _react.useRef(null);
    const isMouseEvent = _react.useRef(false);
    const selectPageByElement = (0, _CarouselContext.useCarouselContext_unstable)((ctx)=>ctx.selectPageByElement);
    const containerRef = (0, _CarouselContext.useCarouselContext_unstable)((ctx)=>ctx.containerRef);
    const { cardFocus } = (0, _CarouselSliderContext.useCarouselSliderContext)();
    const focusAttr = (0, _reacttabster.useFocusableGroup)({
        tabBehavior: 'limited'
    });
    const focusAttrProps = cardFocus ? {
        ...focusAttr,
        tabIndex: 0
    } : {};
    // We attach a unique card id if user does not provide
    const id = (0, _reactutilities.useId)(_useCarouselCardStylesstyles.carouselCardClassNames.root, props.id);
    _react.useEffect(()=>{
        const element = elementRef.current;
        if (element) {
            const listener = (_e)=>{
                const event = _e;
                // When there is no tab index present, only current cards should be visible to accessibility
                if (!cardFocus) {
                    const hidden = !event.detail.isVisible;
                    element.ariaHidden = hidden.toString();
                    element.inert = hidden;
                }
            };
            element.addEventListener(_useEmblaCarousel.EMBLA_VISIBILITY_EVENT, listener);
            return ()=>{
                element.removeEventListener(_useEmblaCarousel.EMBLA_VISIBILITY_EVENT, listener);
            };
        }
    }, [
        cardFocus
    ]);
    const handleFocus = _react.useCallback((e)=>{
        if (!e.defaultPrevented && (0, _reactutilities.isHTMLElement)(e.currentTarget) && !isMouseEvent.current) {
            var _containerRef_current;
            containerRef === null || containerRef === void 0 ? void 0 : (_containerRef_current = containerRef.current) === null || _containerRef_current === void 0 ? void 0 : _containerRef_current.scrollTo(0, 0);
            selectPageByElement(e, e.currentTarget, false);
        }
        // Mouse focus event has been consumed
        isMouseEvent.current = false;
    }, [
        selectPageByElement,
        containerRef
    ]);
    const handlePointerDown = (e)=>{
        if (!e.defaultPrevented) {
            isMouseEvent.current = true;
        }
    };
    const handlePointerUp = (e)=>{
        if (!e.defaultPrevented) {
            isMouseEvent.current = false;
        }
    };
    const onFocusCapture = (0, _reactutilities.mergeCallbacks)(props.onFocusCapture, handleFocus);
    const onPointerUp = (0, _reactutilities.mergeCallbacks)(props.onPointerUp, handlePointerUp);
    const onPointerDown = (0, _reactutilities.mergeCallbacks)(props.onPointerDown, handlePointerDown);
    const state = {
        autoSize,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref: (0, _reactutilities.useMergedRefs)(elementRef, ref),
            role: 'tabpanel',
            tabIndex: cardFocus ? 0 : undefined,
            ...props,
            id,
            onFocusCapture,
            onPointerUp,
            onPointerDown,
            ...focusAttrProps
        }), {
            elementType: 'div'
        })
    };
    return state;
};
