'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    carouselButtonClassNames: function() {
        return carouselButtonClassNames;
    },
    useCarouselButtonStyles_unstable: function() {
        return useCarouselButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reactbutton = require("@fluentui/react-button");
const _reacttheme = require("@fluentui/react-theme");
const carouselButtonClassNames = {
    root: 'fui-CarouselButton',
    icon: 'fui-CarouselButton__icon'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        marginTop: 'auto',
        marginBottom: 'auto',
        color: _reacttheme.tokens.colorNeutralForeground2,
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundAlpha,
        pointerEvents: 'all',
        ':hover': {
            cursor: 'pointer'
        }
    }
});
const useCarouselButtonStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state = {
        ...state,
        ...(0, _reactbutton.useButtonStyles_unstable)(state)
    };
    state.root.className = (0, _react.mergeClasses)(carouselButtonClassNames.root, styles.root, state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(carouselButtonClassNames.icon, state.icon.className);
    }
    return state;
};
