'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    carouselAutoplayButtonClassNames: function() {
        return carouselAutoplayButtonClassNames;
    },
    useCarouselAutoplayButtonStyles_unstable: function() {
        return useCarouselAutoplayButtonStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reactbutton = require("@fluentui/react-button");
const _reacttheme = require("@fluentui/react-theme");
const carouselAutoplayButtonClassNames = {
    root: 'fui-CarouselAutoplayButton',
    icon: 'fui-CarouselAutoplayButton__icon'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        pointerEvents: 'all',
        marginTop: 'auto',
        marginBottom: 'auto',
        ..._react.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke),
        color: _reacttheme.tokens.colorNeutralForeground2,
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundAlpha,
        ':hover': {
            cursor: 'pointer'
        }
    }
});
const useCarouselAutoplayButtonStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    (0, _reactbutton.useToggleButtonStyles_unstable)(state);
    state.root.className = (0, _react.mergeClasses)(carouselAutoplayButtonClassNames.root, styles.root, state.root.className);
    if (state.icon) {
        state.icon.className = (0, _react.mergeClasses)(carouselAutoplayButtonClassNames.icon, state.icon.className);
    }
    return state;
};
