'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCarouselAutoplayButton_unstable", {
    enumerable: true,
    get: function() {
        return useCarouselAutoplayButton_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactbutton = require("@fluentui/react-button");
const _reacticons = require("@fluentui/react-icons");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _CarouselContext = require("../CarouselContext");
const useCarouselAutoplayButton_unstable = (props, ref)=>{
    const { onCheckedChange, checked, defaultChecked } = props;
    const [autoplay, setAutoplay] = (0, _reactutilities.useControllableState)({
        state: checked,
        defaultState: defaultChecked,
        initialState: false
    });
    const enableAutoplay = (0, _CarouselContext.useCarouselContext_unstable)((ctx)=>ctx.enableAutoplay);
    _react.useEffect(()=>{
        // Initialize carousel autoplay based on button state
        enableAutoplay(autoplay);
        return ()=>{
            // We uninitialize autoplay if the button gets unmounted.
            enableAutoplay(false);
        };
    }, [
        autoplay,
        enableAutoplay
    ]);
    const handleClick = (event)=>{
        if (event.isDefaultPrevented()) {
            return;
        }
        const newValue = !autoplay;
        setAutoplay(newValue);
        onCheckedChange === null || onCheckedChange === void 0 ? void 0 : onCheckedChange(event, {
            event,
            type: 'click',
            checked: newValue
        });
    };
    return {
        // We lean on react-button class to handle styling and icon enhancements
        ...(0, _reactbutton.useToggleButton_unstable)({
            icon: _reactutilities.slot.optional(props.icon, {
                defaultProps: {
                    children: autoplay ? /*#__PURE__*/ _react.createElement(_reacticons.PauseCircleRegular, null) : /*#__PURE__*/ _react.createElement(_reacticons.PlayCircleRegular, null)
                },
                renderByDefault: true,
                elementType: 'span'
            }),
            ...props,
            checked: autoplay,
            onClick: (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(handleClick, props.onClick))
        }, ref)
    };
};
