import { ARIAButtonElement } from '@fluentui/react-aria';
import { ARIAButtonSlotProps } from '@fluentui/react-aria';
import { ButtonProps } from '@fluentui/react-button';
import { ButtonSlots } from '@fluentui/react-button';
import { ButtonState } from '@fluentui/react-button';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import { ContextSelector } from '@fluentui/react-context-selector';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import { FC } from 'react';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import { Provider } from 'react';
import { ProviderProps } from 'react';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';
import { ToggleButtonProps } from '@fluentui/react-button';
import { ToggleButtonState } from '@fluentui/react-button';
import { TooltipProps } from '@fluentui/react-tooltip';

/**
 * Carousel is the context wrapper and container for all carousel content/controls,
 * it has no direct style or slot opinions.
 *
 * Carousel also provides API interfaces for callbacks that will occur on navigation events.
 */
export declare const Carousel: ForwardRefComponent<CarouselProps>;

/**
 * Children function replacement, passes through updated context index and carousel information for localization
 */
export declare type CarouselAnnouncerFunction = (index: number, totalSlides: number, slideGroupList: number[][]) => string;

/**
 * If the Carousel is on auto-play, the user may opt into pausing the auto-play feature via the
 * CarouselAutoplayButton which must be present for auto-play to be enabled.
 *
 * If CarouselAutoplayButton is present, auto-play will default to true on mount.
 */
export declare const CarouselAutoplayButton: ForwardRefComponent<CarouselAutoplayButtonProps>;

export declare const carouselAutoplayButtonClassNames: SlotClassNames<CarouselAutoplayButtonSlots>;

/**
 * CarouselAutoplayButton Props
 */
export declare type CarouselAutoplayButtonProps = ToggleButtonProps & ComponentProps<CarouselAutoplayButtonSlots> & {
    /**
     * Callback that informs the user when internal autoplay value has changed
     */
    onCheckedChange?: EventHandler<CarouselAutoplayChangeData>;
};

export declare type CarouselAutoplayButtonSlots = ButtonSlots & {
    root: NonNullable<Slot<ARIAButtonSlotProps>>;
};

/**
 * State used in rendering CarouselAutoplayButton
 */
export declare type CarouselAutoplayButtonState = ToggleButtonState & ComponentState<CarouselAutoplayButtonSlots>;

declare type CarouselAutoplayChangeData = EventData<'click', React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>> & {
    /**
     * The updated autoplay value.
     */
    checked: boolean;
};

/**
 * A default navigation button that will set value to the next/previous page,
 * driven by it's type 'next' or 'previous'.
 */
export declare const CarouselButton: ForwardRefComponent<CarouselButtonProps>;

export declare const carouselButtonClassNames: SlotClassNames<CarouselButtonSlots>;

/**
 * CarouselButton Props
 */
export declare type CarouselButtonProps = Partial<ButtonProps> & ComponentProps<CarouselButtonSlots> & {
    /**
     * Dictates whether button will be of type go next or go previous
     * Default: 'next'
     */
    navType?: 'prev' | 'next';
};

export declare type CarouselButtonSlots = ButtonSlots & {
    root: NonNullable<Slot<ARIAButtonSlotProps>>;
};

/**
 * State used in rendering CarouselButton
 */
export declare type CarouselButtonState = ButtonState & ComponentState<CarouselButtonSlots> & Required<Pick<CarouselButtonProps, 'navType'>>;

/**
 * The defining wrapper of a carousel's indexed content, they will take up the full
 * viewport of CarouselSlider or div wrapper,
 * users may place multiple items within this Card if desired, with consideration of viewport width.
 *
 * Clickable actions within the content area are available via mouse and tab as expected,
 * non-active card content will be set to inert until moved to active card.
 */
export declare const CarouselCard: ForwardRefComponent<CarouselCardProps>;

export declare const carouselCardClassNames: SlotClassNames<CarouselCardSlots>;

/**
 * CarouselCard Props
 */
export declare type CarouselCardProps = ComponentProps<CarouselCardSlots> & {
    /**
     * Sets the card styling to be responsive based on content.
     */
    autoSize?: boolean;
};

export declare type CarouselCardSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering CarouselCard
 */
export declare type CarouselCardState = ComponentState<CarouselCardSlots> & Pick<CarouselCardProps, 'autoSize'>;

export declare const carouselClassNames: SlotClassNames<CarouselSlots>;

export declare const carouselContextDefaultValue: CarouselContextValue;

export declare type CarouselContextValue = {
    activeIndex: number;
    circular: boolean;
    selectPageByElement: (event: React_2.FocusEvent, element: HTMLElement, jump?: boolean) => number;
    selectPageByDirection: (event: React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>, direction: 'next' | 'prev') => number;
    selectPageByIndex: (event: React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>, value: number, jump?: boolean) => void;
    subscribeForValues: (listener: (data: CarouselUpdateData) => void) => () => void;
    enableAutoplay: (autoplay: boolean, temporary?: boolean) => void;
    resetAutoplay: () => void;
    containerRef?: React_2.RefObject<HTMLDivElement | null>;
    viewportRef?: React_2.RefObject<HTMLDivElement | null>;
};

/**
 * Context shared between Carousel and its children components
 */
export declare type CarouselContextValues = {
    carousel: CarouselContextValue;
};

export declare type CarouselIndexChangeData = (EventData<'click', React_2.MouseEvent<HTMLButtonElement | HTMLAnchorElement>> | EventData<'focus', React_2.FocusEvent> | EventData<'drag', PointerEvent | MouseEvent> | EventData<'autoplay', Event>) & {
    /**
     * The index to be set after event has occurred.
     */
    index: number;
};

/**
 * List of integrated motion types
 */
declare type CarouselMotion = 'slide' | {
    kind: 'slide';
    duration?: number;
} | 'fade';

/**
 * Used to jump to a card based on index, using arrow navigation via Tabster.
 *
 * The children of this component will be wrapped in a context to
 * provide the appropriate value based on their index position.
 */
export declare const CarouselNav: ForwardRefComponent<CarouselNavProps>;

/**
 * The child element of CarouselNav, a singular button that will set the carousels active value on click.
 */
export declare const CarouselNavButton: ForwardRefComponent<CarouselNavButtonProps>;

export declare const carouselNavButtonClassNames: SlotClassNames<CarouselNavButtonSlots>;

/**
 * CarouselNavButton Props
 */
export declare type CarouselNavButtonProps = ComponentProps<CarouselNavButtonSlots> & {};

export declare type CarouselNavButtonSlots = {
    /**
     * ARIA compliant nav buttons used to jump to pages
     */
    root: NonNullable<Slot<ARIAButtonSlotProps>>;
};

/**
 * State used in rendering CarouselNavButton
 */
export declare type CarouselNavButtonState = ComponentState<CarouselNavButtonSlots> & {
    /**
     * Enables selection state control
     */
    selected?: boolean;
} & Pick<CarouselNavState, 'appearance'>;

export declare const carouselNavClassNames: SlotClassNames<CarouselNavSlots>;

/**
 * CarouselNavContainer component - This container will provide multiple valid layout options for the underlying carousel controls
 */
export declare const CarouselNavContainer: ForwardRefComponent<CarouselNavContainerProps>;

export declare const carouselNavContainerClassNames: SlotClassNames<CarouselNavContainerSlots>;

/**
 * CarouselNavContainer Props
 */
export declare type CarouselNavContainerProps = ComponentProps<CarouselNavContainerSlots> & {
    /**
     * Default: 'inline'
     * Defines the nav container layout:
     *
     * 'inline' - Default controls inline with carousel view
     *
     *  inline-wide - Similar to inline but places nav buttons on far left/right
     *
     * 'overlay' - Controls overlaid on bottom of carousel viewport,
     *
     * 'overlay-wide' - Controls overlaid on bottom of carousel viewport with prev+autoplay/next buttons on far side
     *
     * 'overlay-expanded' - Controls overlaid on bottom of carousel viewport, with prev/next buttons on sides vertically centered
     */
    layout?: 'inline' | 'inline-wide' | 'overlay' | 'overlay-wide' | 'overlay-expanded';
};

export declare type CarouselNavContainerSlots = {
    root: Slot<'div'>;
    next?: Slot<CarouselButtonProps>;
    nextTooltip?: Slot<TooltipProps>;
    prev?: Slot<CarouselButtonProps>;
    prevTooltip?: Slot<TooltipProps>;
    autoplay?: Slot<typeof CarouselAutoplayButton>;
    autoplayTooltip?: Slot<TooltipProps>;
};

/**
 * State used in rendering CarouselNavContainer
 */
export declare type CarouselNavContainerState = ComponentState<CarouselNavContainerSlots> & Pick<CarouselNavContainerProps, 'layout'>;

declare type CarouselNavContextValue = Pick<CarouselNavState, 'appearance'>;

/**
 * Context shared between CarouselNav and its children components
 */
declare type CarouselNavContextValues = {
    carouselNav: CarouselNavContextValue;
};

/**
 * A variant child element of CarouselNav, a singular image button that displays a
 * preview of card content and will set the carousels active value on click.
 */
export declare const CarouselNavImageButton: ForwardRefComponent<CarouselNavImageButtonProps>;

export declare const carouselNavImageButtonClassNames: SlotClassNames<CarouselNavImageButtonSlots>;

/**
 * CarouselNavImageButton Props
 */
export declare type CarouselNavImageButtonProps = ComponentProps<CarouselNavImageButtonSlots> & {};

export declare type CarouselNavImageButtonSlots = {
    /**
     * ARIA compliant nav buttons used to jump to pages
     */
    root: NonNullable<Slot<ARIAButtonSlotProps>>;
    /**
     * Required: The image within the button
     */
    image: NonNullable<Slot<'img'>>;
};

/**
 * State used in rendering CarouselNavImageButton
 */
export declare type CarouselNavImageButtonState = ComponentState<CarouselNavImageButtonSlots> & {
    /**
     * Enables selection state control
     */
    selected?: boolean;
};

export declare type CarouselNavProps = Omit<ComponentProps<Partial<CarouselNavSlots>>, 'children'> & {
    children: NavButtonRenderFunction;
} & Partial<Pick<CarouselNavState, 'appearance' | 'totalSlides'>>;

export declare type CarouselNavSlots = {
    /**
     * The element wrapping the carousel pagination. By default, this is a div.
     */
    root: NonNullable<Slot<'div'>>;
};

export declare type CarouselNavState = ComponentState<CarouselNavSlots> & {
    /**
     * Enables an alternate brand style when set to 'brand'
     */
    appearance?: 'brand';
    /**
     * The function that will render nav items based on total slides and their index.
     */
    renderNavButton: NavButtonRenderFunction;
    /**
     * The total number of slides available.
     * Users may override if using the component without a Carousel wrapper or implementing custom functionality.
     */
    totalSlides: number;
};

/**
 * Carousel Props
 */
export declare type CarouselProps = ComponentProps<CarouselSlots> & {
    /**
     * The initial page to display in uncontrolled mode.
     */
    defaultActiveIndex?: number;
    /**
     * The alignment of the carousel.
     */
    align?: 'center' | 'start' | 'end';
    /**
     * The value of the currently active page.
     */
    activeIndex?: number;
    /**
     * Callback to notify a page change.
     */
    onActiveIndexChange?: EventHandler<CarouselIndexChangeData>;
    /**
     * Circular enables the carousel to loop back around on navigation past trailing index.
     */
    circular?: boolean;
    /**
     * Controls the number of carousel cards per navigation element, will default to 'auto'
     * Recommended to set to '1' when using full page carousel cards.
     */
    groupSize?: number | 'auto';
    /**
     * Enables drag to scroll on carousel items.
     * Defaults to: False
     */
    draggable?: boolean;
    /**
     * Adds whitespace to start/end so that 'align' prop is always respected for current index
     * Defaults to: False
     */
    whitespace?: boolean;
    /**
     * Sets motion type as either 'slide' or 'fade'
     * Defaults: 'slide'
     *
     * Users can also pass 'slide' & duration via CarouselMotion object to control carousel speed.
     * Drag interactions are not affected because duration is then determined by the drag force.
     *
     * Note: Duration is not in milliseconds because Carousel uses an
     * attraction physics simulation when scrolling instead of easings.
     * Only values between 20-60 are recommended, 25 is the default.
     */
    motion?: CarouselMotion;
    /**
     * Localizes the string used to announce carousel page changes
     * Defaults to: undefined
     */
    announcement?: CarouselAnnouncerFunction;
    /**
     * Choose a delay between autoplay transitions in milliseconds.
     * Only active if Autoplay is enabled via CarouselAutoplayButton
     *
     * Defaults: 4000
     */
    autoplayInterval?: number;
};

export declare const CarouselProvider: Provider<CarouselContextValue | undefined> & FC<ProviderProps<CarouselContextValue | undefined>>;

/**
 * CarouselSlider component - The viewport window that CarouselCards are contained within.
 */
export declare const CarouselSlider: ForwardRefComponent<CarouselSliderProps>;

export declare const carouselSliderClassNames: SlotClassNames<CarouselSliderSlots>;

declare type CarouselSliderContextValue = Pick<CarouselSliderProps, 'cardFocus'>;

/**
 * Context shared between CarouselSlider and its children components
 */
declare type CarouselSliderContextValues = {
    carouselSlider: CarouselSliderContextValue;
};

/**
 * CarouselSlider Props
 */
export declare type CarouselSliderProps = Partial<ComponentProps<CarouselSliderSlots>> & {
    /**
     * cardFocus sets the carousel slider as a focus group,
     * enabling left/right navigation of elements.
     *
     * This will also be passed into CarouselCards via context and set the appropriate focus attributes
     *
     * Defaults: false
     */
    cardFocus?: boolean;
};

export declare type CarouselSliderSlots = {
    /**
     * The root viewport/window of the carousel
     */
    root: Slot<'div'>;
};

/**
 * State used in rendering CarouselSlider
 */
export declare type CarouselSliderState = ComponentState<CarouselSliderSlots> & CarouselSliderContextValue;

export declare type CarouselSlots = {
    root: Slot<'div'>;
};

/**
 * State used in rendering Carousel
 */
export declare type CarouselState = ComponentState<CarouselSlots> & CarouselContextValue;

/**
 * @internal
 */
declare interface CarouselUpdateData {
    /**
     * The current carousel index, a change in index will not trigger the callback (use context index instead).
     */
    activeIndex: number;
    /**
     * The total number of slides to be navigated, accounts for grouping.
     */
    navItemsCount: number;
    /**
     * A breakdown of the card indexes contained within each slide index.
     */
    groupIndexList: number[][];
    /**
     * An array of the card DOM elements after render
     */
    slideNodes: HTMLElement[];
    /**
     * Whether the carousel has enough cards present to enable looping without issues.
     */
    canLoop?: boolean;
}

/**
 * CarouselViewport component - TODO: add more docs
 */
export declare const CarouselViewport: ForwardRefComponent<CarouselViewportProps>;

export declare const carouselViewportClassNames: SlotClassNames<CarouselViewportSlots>;

/**
 * CarouselViewport Props
 */
export declare type CarouselViewportProps = ComponentProps<CarouselViewportSlots>;

export declare type CarouselViewportSlots = {
    /**
     * The viewport outer container, defining the size of the carousels visible and interactable area
     */
    root: Slot<'div'>;
};

/**
 * State used in rendering CarouselViewport
 */
export declare type CarouselViewportState = ComponentState<Required<CarouselViewportSlots>> & CarouselSliderContextValue;

export declare type NavButtonRenderFunction = (index: number) => React_2.ReactNode;

/**
 * Render the final JSX of Carousel
 */
export declare const renderCarousel_unstable: (state: CarouselState, contextValues: CarouselContextValues) => JSXElement;

/**
 * Render the final JSX of CarouselAutoplayButton
 */
export declare const renderCarouselAutoplayButton_unstable: (state: CarouselAutoplayButtonState) => JSXElement;

/**
 * Render the final JSX of CarouselButton
 */
export declare const renderCarouselButton_unstable: (state: CarouselButtonState) => JSXElement;

/**
 * Render the final JSX of CarouselCard
 */
export declare const renderCarouselCard_unstable: (state: CarouselCardState) => JSXElement;

/**
 * Render the final JSX of CarouselNav
 */
export declare const renderCarouselNav_unstable: (state: CarouselNavState, contextValues: CarouselNavContextValues) => JSXElement;

/**
 * Render the final JSX of CarouselNavButton
 */
export declare const renderCarouselNavButton_unstable: (state: CarouselNavButtonState) => JSXElement;

/**
 * Render the final JSX of CarouselNavContainer
 */
export declare const renderCarouselNavContainer_unstable: (state: CarouselNavContainerState) => JSXElement;

/**
 * Render the final JSX of CarouselNavImageButton
 */
export declare const renderCarouselNavImageButton_unstable: (state: CarouselNavImageButtonState) => JSXElement;

/**
 * Render the final JSX of CarouselSlider
 */
export declare const renderCarouselSlider_unstable: (state: CarouselSliderState, contextValues: CarouselSliderContextValues) => JSXElement;

/**
 * Render the final JSX of CarouselViewport
 */
export declare const renderCarouselViewport_unstable: (state: CarouselViewportState, contextValues: CarouselSliderContextValues) => JSXElement;

/**
 * Create the state required to render Carousel.
 *
 * The returned state can be modified with hooks such as useCarouselStyles_unstable,
 * before being passed to renderCarousel_unstable.
 *
 * @param props - props from this instance of Carousel
 * @param ref - reference to root HTMLDivElement of Carousel
 */
export declare function useCarousel_unstable(props: CarouselProps, ref: React_2.Ref<HTMLDivElement>): CarouselState;

/**
 * Create the state required to render CarouselAutoplayButton.
 *
 * The returned state can be modified with hooks such as useCarouselAutoplayButtonStyles_unstable,
 * before being passed to renderCarouselAutoplayButton_unstable.
 *
 * @param props - props from this instance of CarouselAutoplayButton
 * @param ref - reference to root HTMLDivElement of CarouselAutoplayButton
 */
export declare const useCarouselAutoplayButton_unstable: (props: CarouselAutoplayButtonProps, ref: React_2.Ref<ARIAButtonElement>) => CarouselAutoplayButtonState;

/**
 * Apply styling to the CarouselAutoplayButton slots based on the state
 */
export declare const useCarouselAutoplayButtonStyles_unstable: (state: CarouselAutoplayButtonState) => CarouselAutoplayButtonState;

/**
 * Create the state required to render CarouselButton.
 *
 * The returned state can be modified with hooks such as useCarouselButtonStyles_unstable,
 * before being passed to renderCarouselButton_unstable.
 *
 * @param props - props from this instance of CarouselButton
 * @param ref - reference to root HTMLDivElement of CarouselButton
 */
export declare const useCarouselButton_unstable: (props: CarouselButtonProps, ref: React_2.Ref<ARIAButtonElement>) => CarouselButtonState;

/**
 * Apply styling to the CarouselButton slots based on the state
 */
export declare const useCarouselButtonStyles_unstable: (state: CarouselButtonState) => CarouselButtonState;

/**
 * Create the state required to render CarouselCard.
 *
 * The returned state can be modified with hooks such as useCarouselCardStyles_unstable,
 * before being passed to renderCarouselCard_unstable.
 *
 * @param props - props from this instance of CarouselCard
 * @param ref - reference to root HTMLDivElement of CarouselCard
 */
export declare const useCarouselCard_unstable: (props: CarouselCardProps, ref: React_2.Ref<HTMLDivElement>) => CarouselCardState;

/**
 * Apply styling to the CarouselCard slots based on the state
 */
export declare const useCarouselCardStyles_unstable: (state: CarouselCardState) => CarouselCardState;

export declare const useCarouselContext_unstable: <T>(selector: ContextSelector<CarouselContextValue, T>) => T;

/**
 * Create the state required to render CarouselNav.
 *
 * The returned state can be modified with hooks such as useCarouselNavStyles_unstable,
 * before being passed to renderCarouselNav_unstable.
 *
 * @param props - props from this instance of CarouselNav
 * @param ref - reference to root HTMLDivElement of CarouselNav
 */
export declare const useCarouselNav_unstable: (props: CarouselNavProps, ref: React_2.Ref<HTMLDivElement>) => CarouselNavState;

/**
 * Create the state required to render CarouselNavButton.
 *
 * The returned state can be modified with hooks such as useCarouselNavButtonStyles_unstable,
 * before being passed to renderCarouselNavButton_unstable.
 *
 * @param props - props from this instance of CarouselNavButton
 * @param ref - reference to root HTMLDivElement of CarouselNavButton
 */
export declare const useCarouselNavButton_unstable: (props: CarouselNavButtonProps, ref: React_2.Ref<ARIAButtonElement>) => CarouselNavButtonState;

/**
 * Apply styling to the CarouselNavButton slots based on the state
 */
export declare const useCarouselNavButtonStyles_unstable: (state: CarouselNavButtonState) => CarouselNavButtonState;

/**
 * Create the state required to render CarouselNavContainer.
 *
 * The returned state can be modified with hooks such as useCarouselNavContainerStyles_unstable,
 * before being passed to renderCarouselNavContainer_unstable.
 *
 * @param props - props from this instance of CarouselNavContainer
 * @param ref - reference to root HTMLDivElement of CarouselNavContainer
 */
export declare const useCarouselNavContainer_unstable: (props: CarouselNavContainerProps, ref: React_2.Ref<HTMLDivElement>) => CarouselNavContainerState;

/**
 * Apply styling to the CarouselNavContainer slots based on the state
 */
export declare const useCarouselNavContainerStyles_unstable: (state: CarouselNavContainerState) => CarouselNavContainerState;

/**
 * Create the state required to render CarouselNavImageButton.
 *
 * The returned state can be modified with hooks such as useCarouselNavImageButtonStyles_unstable,
 * before being passed to renderCarouselNavImageButton_unstable.
 *
 * @param props - props from this instance of CarouselNavImageButton
 * @param ref - reference to root HTMLButtonElement | HTMLAnchorElement of CarouselNavImageButton
 */
export declare const useCarouselNavImageButton_unstable: (props: CarouselNavImageButtonProps, ref: React_2.Ref<ARIAButtonElement>) => CarouselNavImageButtonState;

/**
 * Apply styling to the CarouselNavImageButton slots based on the state
 */
export declare const useCarouselNavImageButtonStyles_unstable: (state: CarouselNavImageButtonState) => CarouselNavImageButtonState;

/**
 * Apply styling to the CarouselNav slots based on the state
 */
export declare const useCarouselNavStyles_unstable: (state: CarouselNavState) => CarouselNavState;

/**
 * Create the state required to render CarouselSlider.
 *
 * The returned state can be modified with hooks such as useCarouselSliderStyles_unstable,
 * before being passed to renderCarouselSlider_unstable.
 *
 * @param props - props from this instance of CarouselSlider
 * @param ref - reference to root HTMLDivElement of CarouselSlider
 */
export declare const useCarouselSlider_unstable: (props: CarouselSliderProps, ref: React_2.Ref<HTMLDivElement>) => CarouselSliderState;

/**
 * Apply styling to the CarouselSlider slots based on the state
 */
export declare const useCarouselSliderStyles_unstable: (state: CarouselSliderState) => CarouselSliderState;

/**
 * Apply styling to the Carousel slots based on the state
 */
export declare const useCarouselStyles_unstable: (state: CarouselState) => CarouselState;

/**
 * Create the state required to render CarouselViewport.
 *
 * The returned state can be modified with hooks such as useCarouselViewportStyles_unstable,
 * before being passed to renderCarouselViewport_unstable.
 *
 * @param props - props from this instance of CarouselViewport
 * @param ref - reference to root HTMLDivElement of CarouselViewport
 */
export declare const useCarouselViewport_unstable: (props: CarouselViewportProps, ref: React_2.Ref<HTMLDivElement>) => CarouselViewportState;

/**
 * Apply styling to the CarouselViewport slots based on the state
 */
export declare const useCarouselViewportStyles_unstable: (state: CarouselViewportState) => CarouselViewportState;

export { }
