'use client';

import { __styles, mergeClasses, shorthands } from '@griffel/react';
/**
 * Static CSS class names used internally for the component slots.
 */
export const cardHeaderClassNames = {
  root: 'fui-CardHeader',
  image: 'fui-CardHeader__image',
  header: 'fui-CardHeader__header',
  description: 'fui-CardHeader__description',
  action: 'fui-CardHeader__action'
};
/**
 * CSS variable names used internally for uniform styling in CardHeader.
 */
export const cardHeaderCSSVars = {
  cardHeaderGapVar: '--fui-CardHeader--gap'
};
const useStyles = /*#__PURE__*/__styles({
  root: {
    Bkc6ea2: "fkufhic",
    Bt984gj: "f122n59"
  },
  image: {
    mc9l5x: "ftuwxu6",
    t21cq0: ["fql5097", "f6yss9k"]
  },
  header: {
    mc9l5x: "f22iagw"
  },
  description: {
    mc9l5x: "f22iagw"
  },
  action: {
    Frg6f3: ["f6yss9k", "fql5097"],
    B7frvx2: "f1ndzpm5",
    B06c7xf: ["f1fkeggc", "f1u45u6i"],
    B8uq84v: "f16eyofs",
    snkdo8: ["f1u45u6i", "f1fkeggc"],
    Bpf22ct: "f1wkmkig",
    apjfyd: "f18alut9"
  }
}, {
  d: [".fkufhic{--fui-CardHeader--gap:12px;}", ".f122n59{align-items:center;}", ".ftuwxu6{display:inline-flex;}", ".fql5097{margin-right:var(--fui-CardHeader--gap);}", ".f6yss9k{margin-left:var(--fui-CardHeader--gap);}", ".f22iagw{display:flex;}"],
  m: [["@media (forced-colors: active){.f1ndzpm5 .fui-Button,.f1ndzpm5 .fui-Link{border-top-color:currentColor;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1fkeggc .fui-Button,.f1fkeggc .fui-Link{border-right-color:currentColor;}.f1u45u6i .fui-Button,.f1u45u6i .fui-Link{border-left-color:currentColor;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f16eyofs .fui-Button,.f16eyofs .fui-Link{border-bottom-color:currentColor;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f1wkmkig .fui-Button,.f1wkmkig .fui-Link{color:currentColor;}}", {
    m: "(forced-colors: active)"
  }], ["@media (forced-colors: active){.f18alut9 .fui-Button,.f18alut9 .fui-Link{outline-color:currentColor;}}", {
    m: "(forced-colors: active)"
  }]]
});
const useStylesGrid = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f13qh94s",
    t4k1zu: "f8a668j"
  },
  image: {
    Br312pm: "fwpfdsa",
    Ijaq50: "fldnz9j"
  },
  header: {
    Br312pm: "fd46tj4",
    Ijaq50: "f16hsg94"
  },
  description: {
    Br312pm: "fd46tj4",
    Ijaq50: "faunodf"
  },
  action: {
    Br312pm: "fis13di",
    Ijaq50: "fldnz9j"
  }
}, {
  d: [".f13qh94s{display:grid;}", ".f8a668j{grid-auto-columns:min-content 1fr min-content;}", ".fwpfdsa{grid-column-start:1;}", ".fldnz9j{grid-row-start:span 2;}", ".fd46tj4{grid-column-start:2;}", ".f16hsg94{grid-row-start:1;}", ".faunodf{grid-row-start:2;}", ".fis13di{grid-column-start:3;}"]
});
const useStylesFlex = /*#__PURE__*/__styles({
  root: {
    mc9l5x: "f22iagw"
  },
  header: {
    Bh6795r: "fqerorx"
  },
  image: {},
  description: {},
  action: {}
}, {
  d: [".f22iagw{display:flex;}", ".fqerorx{flex-grow:1;}"]
});
/**
 * Apply styling to the CardHeader slots based on the state.
 */
export const useCardHeaderStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  const stylesGrid = useStylesGrid();
  const stylesFlex = useStylesFlex();
  const boxModelStyles = state.description ? stylesGrid : stylesFlex;
  const getSlotStyles = slotName => {
    var _state_slotName;
    return mergeClasses(cardHeaderClassNames[slotName], styles[slotName], boxModelStyles[slotName], (_state_slotName = state[slotName]) === null || _state_slotName === void 0 ? void 0 : _state_slotName.className);
  };
  state.root.className = getSlotStyles('root');
  if (state.image) {
    state.image.className = getSlotStyles('image');
  }
  if (state.header) {
    state.header.className = getSlotStyles('header');
  }
  if (state.description) {
    state.description.className = getSlotStyles('description');
  }
  if (state.action) {
    state.action.className = getSlotStyles('action');
  }
  return state;
};