'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    cardPreviewClassNames: function() {
        return cardPreviewClassNames;
    },
    useCardPreviewStyles_unstable: function() {
        return useCardPreviewStyles_unstable;
    }
});
const _react = require("@griffel/react");
const cardPreviewClassNames = {
    root: 'fui-CardPreview',
    logo: 'fui-CardPreview__logo'
};
const useStyles = (0, _react.makeStyles)({
    root: {
        position: 'relative',
        [`> :not(.${cardPreviewClassNames.logo})`]: {
            display: 'block',
            height: '100%',
            width: '100%'
        }
    },
    logo: {
        position: 'absolute',
        bottom: '12px',
        left: '12px',
        width: '32px',
        height: '32px'
    }
});
const useCardPreviewStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(cardPreviewClassNames.root, styles.root, state.root.className);
    if (state.logo) {
        state.logo.className = (0, _react.mergeClasses)(cardPreviewClassNames.logo, styles.logo, state.logo.className);
    }
    return state;
};
