'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCardPreview_unstable", {
    enumerable: true,
    get: function() {
        return useCardPreview_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _CardContext = require("../Card/CardContext");
const _useCardPreviewStylesstyles = require("./useCardPreviewStyles.styles");
const useCardPreview_unstable = (props, ref)=>{
    const { logo } = props;
    const { selectableA11yProps: { referenceLabel, referenceId, setReferenceLabel, setReferenceId } } = (0, _CardContext.useCardContext_unstable)();
    // FIXME:
    // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
    // but since it would be a breaking change to fix it, we are casting ref to it's proper type
    const previewRef = (0, _reactutilities.useMergedRefs)(ref, _react.useRef(null));
    _react.useEffect(()=>{
        if (referenceLabel && referenceId) {
            return;
        }
        if (previewRef.current && previewRef.current.parentNode) {
            const img = previewRef.current.parentNode.querySelector(`.${_useCardPreviewStylesstyles.cardPreviewClassNames.root} > img`);
            if (img) {
                const ariaLabel = img.getAttribute('aria-label');
                const ariaDescribedby = img.getAttribute('aria-describedby');
                if (ariaDescribedby) {
                    setReferenceId(ariaDescribedby);
                } else if (img.alt) {
                    setReferenceLabel(img.alt);
                } else if (ariaLabel) {
                    setReferenceLabel(ariaLabel);
                }
            }
        }
    }, [
        setReferenceLabel,
        referenceLabel,
        previewRef,
        referenceId,
        setReferenceId
    ]);
    return {
        components: {
            root: 'div',
            logo: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref: previewRef,
            ...props
        }), {
            elementType: 'div'
        }),
        logo: _reactutilities.slot.optional(logo, {
            elementType: 'div'
        })
    };
};
