'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCardHeader_unstable", {
    enumerable: true,
    get: function() {
        return useCardHeader_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _CardContext = require("../Card/CardContext");
const _useCardHeaderStylesstyles = require("./useCardHeaderStyles.styles");
/**
 * Finds the first child of CardHeader with an id prop.
 *
 * @param header - the header prop of CardHeader
 */ function getChildWithId(header) {
    function isReactElementWithIdProp(element) {
        return /*#__PURE__*/ _react.isValidElement(element) && Boolean(element.props.id);
    }
    return _react.Children.toArray(header).find(isReactElementWithIdProp);
}
/**
 * Returns the id to use for the CardHeader root element.
 *
 * @param headerId - the id prop of the CardHeader component
 * @param childWithId - the first child of the CardHeader component with an id prop
 * @param generatedId - a generated id
 *
 * @returns the id to use for the CardHeader root element
 */ function getReferenceId(headerId, childWithId, generatedId) {
    if (headerId) {
        return headerId;
    }
    if (childWithId === null || childWithId === void 0 ? void 0 : childWithId.props.id) {
        return childWithId.props.id;
    }
    return generatedId;
}
const useCardHeader_unstable = (props, ref)=>{
    const { image, header, description, action } = props;
    const { selectableA11yProps: { referenceId, setReferenceId } } = (0, _CardContext.useCardContext_unstable)();
    const headerRef = _react.useRef(null);
    const hasChildId = _react.useRef(false);
    const generatedId = (0, _reactutilities.useId)(_useCardHeaderStylesstyles.cardHeaderClassNames.header, referenceId);
    const headerSlot = _reactutilities.slot.optional(header, {
        renderByDefault: true,
        defaultProps: {
            ref: headerRef,
            id: !hasChildId.current ? referenceId : undefined
        },
        elementType: 'div'
    });
    _react.useEffect(()=>{
        var _headerRef_current;
        const headerId = !hasChildId.current ? (_headerRef_current = headerRef.current) === null || _headerRef_current === void 0 ? void 0 : _headerRef_current.id : undefined;
        const childWithId = getChildWithId(headerSlot === null || headerSlot === void 0 ? void 0 : headerSlot.children);
        hasChildId.current = Boolean(childWithId);
        setReferenceId(getReferenceId(headerId, childWithId, generatedId));
    }, [
        generatedId,
        header,
        headerSlot,
        setReferenceId
    ]);
    return {
        components: {
            root: 'div',
            image: 'div',
            header: 'div',
            description: 'div',
            action: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: ref,
            ...props
        }), {
            elementType: 'div'
        }),
        image: _reactutilities.slot.optional(image, {
            elementType: 'div'
        }),
        header: headerSlot,
        description: _reactutilities.slot.optional(description, {
            elementType: 'div'
        }),
        action: _reactutilities.slot.optional(action, {
            elementType: 'div'
        })
    };
};
