'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    cardFooterClassNames: function() {
        return cardFooterClassNames;
    },
    useCardFooterStyles_unstable: function() {
        return useCardFooterStyles_unstable;
    }
});
const _react = require("@griffel/react");
const cardFooterClassNames = {
    root: 'fui-CardFooter',
    action: 'fui-CardFooter__action'
};
const useStyles = (0, _react.makeStyles)({
    root: {
        display: 'flex',
        flexDirection: 'row',
        gap: '12px'
    },
    action: {
        marginLeft: 'auto',
        // when the card is selected or hovered, it has custom high contrast color and background styles
        // setting this ensures action buttons adopt those colors and are still visible in forced-colors mode
        '@media (forced-colors: active)': {
            '& .fui-Button, & .fui-Link': {
                ..._react.shorthands.borderColor('currentColor'),
                color: 'currentColor',
                outlineColor: 'currentColor'
            }
        }
    }
});
const useCardFooterStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(cardFooterClassNames.root, styles.root, state.root.className);
    if (state.action) {
        state.action.className = (0, _react.mergeClasses)(cardFooterClassNames.action, styles.action, state.action.className);
    }
    return state;
};
