'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    cardCSSVars: function() {
        return cardCSSVars;
    },
    cardClassNames: function() {
        return cardClassNames;
    },
    useCardStyles_unstable: function() {
        return useCardStyles_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _react1 = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttext = require("@fluentui/react-text");
const _reacttabster = require("@fluentui/react-tabster");
const _useCardPreviewStylesstyles = require("../CardPreview/useCardPreviewStyles.styles");
const _useCardHeaderStylesstyles = require("../CardHeader/useCardHeaderStyles.styles");
const _useCardFooterStylesstyles = require("../CardFooter/useCardFooterStyles.styles");
const cardClassNames = {
    root: 'fui-Card',
    floatingAction: 'fui-Card__floatingAction',
    checkbox: 'fui-Card__checkbox'
};
const cardCSSVars = {
    cardSizeVar: '--fui-Card--size',
    cardBorderRadiusVar: '--fui-Card--border-radius'
};
const focusOutlineStyle = {
    outlineRadius: `var(${cardCSSVars.cardBorderRadiusVar})`,
    outlineWidth: _reacttheme.tokens.strokeWidthThick,
    outlineOffset: '-2px'
};
const useCardResetStyles = (0, _react1.makeResetStyles)({
    overflow: 'hidden',
    borderRadius: `var(${cardCSSVars.cardBorderRadiusVar})`,
    padding: `var(${cardCSSVars.cardSizeVar})`,
    gap: `var(${cardCSSVars.cardSizeVar})`,
    display: 'flex',
    position: 'relative',
    boxSizing: 'border-box',
    color: _reacttheme.tokens.colorNeutralForeground1,
    // Border setting using after pseudo element to allow CardPreview to render behind it.
    '::after': {
        position: 'absolute',
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        content: '""',
        pointerEvents: 'none',
        ..._react1.shorthands.borderStyle('solid'),
        ..._react1.shorthands.borderWidth(_reacttheme.tokens.strokeWidthThin),
        borderRadius: `var(${cardCSSVars.cardBorderRadiusVar})`
    },
    // Prevents CardHeader and CardFooter from shrinking.
    [`> .${_useCardHeaderStylesstyles.cardHeaderClassNames.root}, > .${_useCardFooterStylesstyles.cardFooterClassNames.root}`]: {
        flexShrink: 0
    }
});
const disabledStyles = {
    cursor: 'not-allowed',
    userSelect: 'none',
    color: _reacttheme.tokens.colorNeutralForegroundDisabled,
    backgroundColor: _reacttheme.tokens.colorNeutralBackgroundDisabled,
    boxShadow: _reacttheme.tokens.shadow2,
    ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
    '::before': {
        content: '""',
        position: 'absolute',
        inset: 0,
        zIndex: `calc(${_reacttheme.tokens.zIndexContent} + 1)`
    },
    '::after': {
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled)
    }
};
const useCardStyles = (0, _react1.makeStyles)({
    focused: {
        ...(0, _reacttabster.createFocusOutlineStyle)({
            style: focusOutlineStyle,
            selector: 'focus'
        })
    },
    selectableFocused: (0, _reacttabster.createFocusOutlineStyle)({
        style: focusOutlineStyle,
        selector: 'focus-within'
    }),
    orientationHorizontal: {
        flexDirection: 'row',
        alignItems: 'center',
        // Remove vertical padding to keep CardPreview content flush with Card's borders.
        [`> .${_useCardPreviewStylesstyles.cardPreviewClassNames.root}`]: {
            marginTop: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`,
            marginBottom: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`
        },
        // Due to Tabster's "Groupper" focus functionality, hidden elements are injected before and after Card's content.
        // As such, the code below targets a CardPreview, when it's the first element.
        // Since this is on horizontal cards, the left padding is removed to keep the content flush with the border.
        [`> :not([aria-hidden="true"]).${_useCardPreviewStylesstyles.cardPreviewClassNames.root}:first-of-type`]: {
            marginLeft: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`
        },
        // Due to Tabster's "Groupper" focus functionality, hidden elements are injected before and after Card's content.
        // As such, the code below targets a CardPreview, when it's the last element.
        // Since this is on horizontal cards, the right padding is removed to keep the content flush with the border.
        [`> :not([aria-hidden="true"]).${_useCardPreviewStylesstyles.cardPreviewClassNames.root}:last-of-type`]: {
            marginRight: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`
        },
        // If the last child is a CardHeader or CardFooter, allow it to grow to fill the available space.
        [`> .${_useCardHeaderStylesstyles.cardHeaderClassNames.root}:last-of-type, > .${_useCardFooterStylesstyles.cardFooterClassNames.root}:last-of-type`]: {
            flexGrow: 1
        }
    },
    orientationVertical: {
        flexDirection: 'column',
        // Remove lateral padding to keep CardPreview content flush with Card's borders.
        [`> .${_useCardPreviewStylesstyles.cardPreviewClassNames.root}`]: {
            marginLeft: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`,
            marginRight: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`
        },
        // Due to Tabster's "Groupper" focus functionality, hidden elements are injected before and after Card's content.
        // As such, the code below targets a CardPreview, when it's the first element.
        // Since this is on vertical cards, the top padding is removed to keep the content flush with the border.
        [`> :not([aria-hidden="true"]).${_useCardPreviewStylesstyles.cardPreviewClassNames.root}:first-of-type`]: {
            marginTop: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`
        },
        [`> .${cardClassNames.floatingAction} + .${_useCardPreviewStylesstyles.cardPreviewClassNames.root}`]: {
            marginTop: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`
        },
        // Due to Tabster's "Groupper" focus functionality, hidden elements are injected before and after Card's content.
        // As such, the code below targets a CardPreview, when it's the first element.
        // Since this is on vertical cards, the bottom padding is removed to keep the content flush with the border.
        [`> :not([aria-hidden="true"]).${_useCardPreviewStylesstyles.cardPreviewClassNames.root}:last-of-type`]: {
            marginBottom: `calc(var(${cardCSSVars.cardSizeVar}) * -1)`
        }
    },
    sizeSmall: {
        [cardCSSVars.cardSizeVar]: '8px',
        [cardCSSVars.cardBorderRadiusVar]: _reacttheme.tokens.borderRadiusSmall
    },
    sizeMedium: {
        [cardCSSVars.cardSizeVar]: '12px',
        [cardCSSVars.cardBorderRadiusVar]: _reacttheme.tokens.borderRadiusMedium
    },
    sizeLarge: {
        [cardCSSVars.cardSizeVar]: '16px',
        [cardCSSVars.cardBorderRadiusVar]: _reacttheme.tokens.borderRadiusLarge
    },
    interactive: {
        [`& .${_reacttext.textClassNames.root}`]: {
            color: 'currentColor'
        }
    },
    filled: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        boxShadow: _reacttheme.tokens.shadow4,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
        }
    },
    filledInteractive: {
        cursor: 'pointer',
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        boxShadow: _reacttheme.tokens.shadow4,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Hover,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1Hover,
            boxShadow: _reacttheme.tokens.shadow8
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1Pressed
        }
    },
    filledInteractiveSelected: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1Selected,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Selected)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Selected,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground1Selected
        }
    },
    filledAlternative: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground2,
        boxShadow: _reacttheme.tokens.shadow4,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
        }
    },
    filledAlternativeInteractive: {
        cursor: 'pointer',
        backgroundColor: _reacttheme.tokens.colorNeutralBackground2,
        boxShadow: _reacttheme.tokens.shadow4,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground2Hover,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground2Hover,
            boxShadow: _reacttheme.tokens.shadow8
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorNeutralBackground2Pressed
        }
    },
    filledAlternativeInteractiveSelected: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackground2Selected,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Selected)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground2Selected,
            backgroundColor: _reacttheme.tokens.colorNeutralBackground2Selected
        }
    },
    outline: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        boxShadow: 'none',
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1)
        }
    },
    outlineInteractive: {
        cursor: 'pointer',
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        boxShadow: 'none',
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Hover,
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundHover,
            '::after': {
                ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Hover)
            }
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundPressed,
            '::after': {
                ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Pressed)
            }
        }
    },
    outlineInteractiveSelected: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackgroundSelected,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Selected)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Selected,
            backgroundColor: _reacttheme.tokens.colorTransparentBackgroundSelected
        }
    },
    outlineDisabled: {
        backgroundColor: _reacttheme.tokens.colorTransparentBackground,
        boxShadow: 'none',
        ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled),
        '&:hover, &:active': {
            backgroundColor: _reacttheme.tokens.colorTransparentBackground,
            boxShadow: 'none'
        },
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStrokeDisabled)
        }
    },
    subtle: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        boxShadow: 'none',
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
        }
    },
    subtleInteractive: {
        cursor: 'pointer',
        backgroundColor: _reacttheme.tokens.colorSubtleBackground,
        boxShadow: 'none',
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorTransparentStroke)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Hover,
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundHover
        },
        ':active': {
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundPressed
        }
    },
    subtleInteractiveSelected: {
        backgroundColor: _reacttheme.tokens.colorSubtleBackgroundSelected,
        '::after': {
            ..._react1.shorthands.borderColor(_reacttheme.tokens.colorNeutralStroke1Selected)
        },
        ':hover': {
            color: _reacttheme.tokens.colorNeutralForeground1Selected,
            backgroundColor: _reacttheme.tokens.colorSubtleBackgroundSelected
        }
    },
    highContrastSelected: {
        '@media (forced-colors: active)': {
            forcedColorAdjust: 'none',
            backgroundColor: 'Highlight',
            color: 'HighlightText',
            [`& .${_useCardPreviewStylesstyles.cardPreviewClassNames.root}, & .${_useCardFooterStylesstyles.cardFooterClassNames.root}`]: {
                forcedColorAdjust: 'auto'
            },
            '::after': {
                ..._react1.shorthands.borderColor('Highlight')
            }
        }
    },
    highContrastInteractive: {
        '@media (forced-colors: active)': {
            ':hover, :active': {
                forcedColorAdjust: 'none',
                backgroundColor: 'Highlight',
                color: 'HighlightText',
                [`& .${_useCardPreviewStylesstyles.cardPreviewClassNames.root}, & .${_useCardFooterStylesstyles.cardFooterClassNames.root}`]: {
                    forcedColorAdjust: 'auto'
                }
            },
            '::after': {
                ..._react1.shorthands.borderColor('Highlight')
            }
        }
    },
    select: {
        position: 'absolute',
        top: '4px',
        right: '4px',
        zIndex: _reacttheme.tokens.zIndexContent
    },
    hiddenCheckbox: {
        overflow: 'hidden',
        width: '1px',
        height: '1px',
        position: 'absolute',
        clip: 'rect(0 0 0 0)',
        clipPath: 'inset(50%)',
        whiteSpace: 'nowrap'
    },
    disabled: {
        ...disabledStyles,
        '&:hover, &:active': disabledStyles
    }
});
const useCardStyles_unstable = (state)=>{
    'use no memo';
    const resetStyles = useCardResetStyles();
    const styles = useCardStyles();
    const orientationMap = {
        horizontal: styles.orientationHorizontal,
        vertical: styles.orientationVertical
    };
    const sizeMap = {
        small: styles.sizeSmall,
        medium: styles.sizeMedium,
        large: styles.sizeLarge
    };
    const appearanceMap = {
        filled: styles.filled,
        'filled-alternative': styles.filledAlternative,
        outline: styles.outline,
        subtle: styles.subtle
    };
    const selectedMap = {
        filled: styles.filledInteractiveSelected,
        'filled-alternative': styles.filledAlternativeInteractiveSelected,
        outline: styles.outlineInteractiveSelected,
        subtle: styles.subtleInteractiveSelected
    };
    const interactiveMap = {
        filled: styles.filledInteractive,
        'filled-alternative': styles.filledAlternativeInteractive,
        outline: styles.outlineInteractive,
        subtle: styles.subtleInteractive
    };
    const isSelectableOrInteractive = !state.disabled && (state.interactive || state.selectable);
    const focusedClassName = _react.useMemo(()=>{
        if (state.disabled) {
            return '';
        }
        if (state.selectable) {
            if (state.selectFocused) {
                return styles.selectableFocused;
            }
            return '';
        }
        return styles.focused;
    }, [
        state.disabled,
        state.selectFocused,
        state.selectable,
        styles.focused,
        styles.selectableFocused
    ]);
    state.root.className = (0, _react1.mergeClasses)(cardClassNames.root, resetStyles, orientationMap[state.orientation], sizeMap[state.size], appearanceMap[state.appearance], isSelectableOrInteractive && styles.interactive, isSelectableOrInteractive && interactiveMap[state.appearance], state.selected && selectedMap[state.appearance], focusedClassName, isSelectableOrInteractive && styles.highContrastInteractive, state.selected && styles.highContrastSelected, state.disabled && styles.disabled, state.disabled && state.appearance === 'outline' && styles.outlineDisabled, state.root.className);
    if (state.floatingAction) {
        state.floatingAction.className = (0, _react1.mergeClasses)(cardClassNames.floatingAction, styles.select, state.floatingAction.className);
    }
    if (state.checkbox) {
        state.checkbox.className = (0, _react1.mergeClasses)(cardClassNames.checkbox, styles.hiddenCheckbox, state.checkbox.className);
    }
    return state;
};
